% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{splitsampStats}
\alias{splitsampStats}
\title{Statistics for splitsamp Networks}
\usage{
splitsampStats(object, stats = c("edges", "centralities"),
  edges = c("lower", "upper"))
}
\arguments{
\item{object}{Object output from \emph{splitsampNet} function}

\item{stats}{Which stats should be computed?
"edges" will compute statistics for the \emph{edgerep} function.
"centralities" will compute betweenness, closeness, and strength.
Both options are allowed}

\item{edges}{If stats = "edges, should the lower or upper replication percentage be used?
Defaults to "lower".}
}
\value{
Returns a list of statistics for edges (Edges), centralities (Centralities), or both
}
\description{
Applies a network statistics to the networks generated from the splitsampNet function
}
\examples{
samples <- splitsamp(neoOpen)

nets <- splitsampNet(samples, method="TMFG")

stats <- splitsampStats(nets, stats = "edges", edges = "lower")
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
