% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{neuralnetfilter}
\alias{neuralnetfilter}
\title{Neural Network Filter}
\usage{
neuralnetfilter(neuralarray, method = c("TMFG", "MaST", "ECOplusMaST", "ECO",
  "threshold"), progBar = TRUE, ...)
}
\arguments{
\item{neuralarray}{Array from \emph{convertConnBrainMat} function}

\item{method}{Filtering method to be applied}

\item{progBar}{Should progress bar be displayed?
Defaults to TRUE.
Set FALSE for no progress bar}

\item{...}{Additional arguments from filtering methods}
}
\value{
Returns an array of n x n x m filtered matrices
}
\description{
Applies a network filtering methodology to neural network array.
Removes edges from the neural network output from \emph{convertConnBrainMat} using a network filtering approach
}
\examples{
\dontrun{neuralarray <- convertConnBrainMat()

filteredneuralarray <- neuralnetfilter(neuralarray, method = "threshold", thresh = .50)

dependencyarray <- depna(neuralarray)

filtereddependencyarray <- neuralnetfilter(dependencyarray, method = "TMFG", depend = TRUE)
}
}
\references{
Fallani, F. D. V., Latora, V., & Chavez, M. (2017).
A topological criterion for filtering information in complex brain networks.
\emph{PLoS Computational Biology}, \emph{13}(1), e1005305.

Massara, G. P., Di Matteo, T., & Aste, T. (2016).
Network filtering for big data: Triangulated maximally filtered graph.
\emph{Journal of Complex Networks}, \emph{5}(2), 161-178.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
