% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{Distance}
\alias{Distance}
\title{Distance}
\usage{
Distance(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted? Defaults to FALSE. Set to TRUE for weighted measure of distance}
}
\value{
A distance matrix of the network
}
\description{
Computes distance matrix of the network (Weighted not coded)
}
\examples{
unweighted_D<-Distance(A)

weighted_D<-Distance(A,weighted=TRUE)
}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
Neuroimage, 52(3), 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
