% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCC_Histogram.R
\name{Histogram_LCC}
\alias{Histogram_LCC}
\title{Histogram_LCC}
\usage{
Histogram_LCC(LCC_L, Name = NULL)
}
\arguments{
\item{LCC_L}{an output from the function LCC_Significance or LCC_Bipartide}

\item{Name}{title of the plot}
}
\value{
An Histogram of the simulated LCC, and a red line of the actual LCC.
}
\description{
Plots the histogram to evaluate the significance of the Largest Connected Component (LCC).
}
\examples{
set.seed(666)
net  = data.frame(
Node.1 = sample(LETTERS[1:15], 15, replace = TRUE),
Node.2 = sample(LETTERS[1:10], 15, replace = TRUE))
net$value = 1
net =  CoDiNA::OrderNames(net)
net = unique(net)

g <- igraph::graph_from_data_frame(net, directed = FALSE )
targets = c("N", "A", "I", "F")
LCC_Out = LCC_Significance(N = 1000,
                 Targets = targets,
                                  G = g,
                                  bins = 5,
                                  min_per_bin = 2)
                                  # in a real interactome, please use the default

Histogram_LCC(LCC_Out, "Example")
}
