% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myFUN.R
\docType{package}
\name{NPMLEmix-package}
\alias{NPMLEmix-package}
\title{Likelihood based inference in mixture models and multiple hypotheses testing}
\description{
The NPMLEmix-package fits nonparametric Gaussian location mixture models for
z-scores arising out of several hypotheses, while taking into account any
available covariate information. It also provides three important functions:
marg1(), marg2() (both based on marginal likelihoods), npmleEM() (based on
joint data likelihood) for inference in multiple testing.
}
\details{
\eqn{(Y_1,X_1),\ldots ,(X_n,Y_n)} are i.i.d. samples drawn from the model,
\deqn{Y|X=x\sim (1-\pi^*(x))\phi(y)+\pi^*(x)\underbrace{\int_{\theta}\phi(y-\theta)\,dG(\theta)}_{\phi_1(y)}, \qquad X\sim m_X(\cdot)}
where \eqn{\pi^*(\cdot)} represents the logistic link function, \eqn{\phi(\cdot)} is
the standard Gaussian density and \eqn{G(\cdot)} is some unknown probability measure on
the real line. Usually, \eqn{\pi^*(\cdot)} is referred to as the \emph{signal proportion},
\eqn{\phi_1(\cdot)} is called the \emph{signal density} and \eqn{G(\cdot)} is called \emph{mixing distribution}.
The \eqn{i^{th}} local false discovery rate is then defined as
\deqn{lfdr_i=\frac{(1-\pi^*(X_i))\phi_0(Y_i)}{(1-\pi^*(X_i))\phi_0(Y_i)+\pi^*(X_i)\phi_1(Y_i)}}
All the principal functions estimate the unknown parameters - \eqn{\pi^*(\cdot)} and
\eqn{\phi_1(\cdot)}, and consequently the \eqn{lfdr_i}'s.
The optimization algorithms use quasi-Newton routines such as the BFGS (Broyden-Fletcher-Goldfarb-Shanno)
algorithm and the separable convex optimization routine available in the Rmosek
optimization suite.
The principal functions accept a vector of z-scores (\eqn{Y})'s and a covariate matrix X
in their list of arguments. Read the documentations for each function to
check whether or not to add a column of \eqn{1}'s to X matrix.
}
\section{Functions}{

The principal functions in the NPMLEmix-package: marg1(), marg2(), npmleEM().
}

\references{
Deb, N., Saha, S., Guntuboyina, A. and Sen, B., 2018. Two-component Mixture Model in the Presence of Covariates. arXiv preprint arXiv:1810.07897.

Scott, J.G., Kelly, R.C., Smith, M.A., Zhou, P. and Kass, R.E., 2015. False discovery rate regression: an application to neural synchrony detection in primary visual cortex. Journal of the American Statistical Association, 110(510), pp.459-471.

Efron, B., 2005. Local false discovery rates.

Koenker, R. and Mizera, I., 2014. Convex optimization in R. Journal of Statistical Software, 60(5), pp.1-23.


### Using the makedata() method ###

x=cbind(runif(1000),runif(1000))
n=1000
atoms=c(-2,0,2)
probs=c(0.48,0.04,0.48)
variances=c(1,16,1)
sx=c(-3,1.5,1.5)
### Generating the data ###
st=makedata(n,x,sx,atoms,probs,variances)
### Output the vector of local false discovery rates ###
st$localfdr


### Using the marg1() method ###
st=makedata(100,cbind(runif(100),runif(100)),c(0,1,-1),c(0,1),c(0.4,0.6),c(1,1))

### Use the default rejection level ###
defm1=marg1(st$y, cbind(1, st$xs))
### Use a new rejection level of 0.1 ###
nodefm1=marg1(st$y, cbind(1, st$xs), level = 0.1)
### Output the vector of prior probabilities ###
defm1$p
### Output the rejection set ###
nodefm1$rejset


### Using the marg2() method ###
st=makedata(100,cbind(runif(100),runif(100)),c(0,1,-1),c(0,1),c(0.4,0.6),c(1,1))

### Use the default rejection level ###
defm2=marg2(st$y, cbind(1, st$xs))
### Use a new rejection level of 0.1 ###
nodefm2=marg2(st$y, cbind(1, st$xs), level = 0.1)
### Output the vector of prior probabilities ###
defm2$p
### Output the rejection set ###
nodefm2$rejset


### Using the npmleEM() method ###
st=makedata(100,cbind(runif(100),runif(100)),c(0,1,-1),c(0,1),c(0.4,0.6),c(1,1))

### Use the default rejection level and default initialization ###
npmle1=npmleEM(st$y, cbind(1, st$xs))
### Use a new rejection level of 0.1 and marg2() initialization ###
npmle2=npmleEM(st$y, cbind(1, st$xs), level = 0.1, initp = 2)
#' ### Use a new rejection level of 0.1 and FDRreg() initialization ###
npmle3=npmleEM(st$y, cbind(1, st$xs), level = 0.1, initp = 3)
### Use the best initialization among marg1(), marg2() and FDRreg()###
npmle4=npmleEM(st$y, cbind(1, st$xs), level = 0.2, initp = 4)
### Output the vector of prior probabilities ###
npmle1$p
### Output the rejection set ###
npmle2$rejset
### Output the vector of local false discovery rates ###
npmle3$localfdr
### Output the vector of estimated conditional densities ###
npmle4$den
}
