% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{UPM.ratio}
\alias{UPM.ratio}
\title{Upper Partial Moment RATIO}
\usage{
UPM.ratio(degree, target, variable)
}
\arguments{
\item{degree}{integer; \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; Typically set to mean, but does not have to be. (Vectorized)}

\item{variable}{a numeric vector.}
}
\value{
Standardized UPM of variable
}
\description{
This function generates a standardized univariate upper partial moment for any degree or target.
}
\examples{
set.seed(123)
x <- rnorm(100)
UPM.ratio(0, mean(x), x)

## Joint Upper CDF
\dontrun{
x <- rnorm(5000) ; y <- rnorm(5000)
plot3d(x, y, Co.UPM(0, sort(x), sort(y), x, y), col = "blue", xlab = "X", ylab = "Y",
zlab = "Probability", box = FALSE)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments" (ISBN: 1490523995)
}
\author{
Fred Viole, OVVO Financial Systems
}
