% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{NNS.moments}
\alias{NNS.moments}
\title{NNS moments}
\usage{
NNS.moments(x, population = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{population}{logical; \code{TRUE} (default) Performs the population adjustment.  Otherwise returns the sample statistic.}
}
\value{
Returns:
\itemize{
 \item{\code{"$mean"}} mean of the distribution.
 \item{\code{"$variance"}} variance of the distribution.
 \item{\code{"$skewness"}} skewness of the distribution.
 \item{\code{"$kurtosis"}} excess kurtosis of the distribution.
}
}
\description{
This function returns the first 4 moments of the distribution.
}
\examples{
\dontrun{
set.seed(123)
x <- rnorm(100)
NNS.moments(x)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}
}
\author{
Fred Viole, OVVO Financial Systems
}
