% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LPM.ratio}
\alias{LPM.ratio}
\title{Lower Partial Moment RATIO}
\usage{
LPM.ratio(degree, target, variable)
}
\arguments{
\item{degree}{integer; \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; Typically set to mean, but does not have to be. (Vectorized)}

\item{variable}{a numeric vector.}
}
\value{
Standardized LPM of variable
}
\description{
This function generates a standardized univariate lower partial moment for any degree or target.
}
\examples{
set.seed(123)
x <- rnorm(100)
LPM.ratio(0, mean(x), x)

\dontrun{
## Empirical CDF (degree = 0)
lpm_cdf <- LPM.ratio(0, sort(x), x)
plot(sort(x), lpm_cdf)

## Continuous CDF (degree = 1)
lpm_cdf_1 <- LPM.ratio(1, sort(x), x)
plot(sort(x), lpm_cdf_1)

## Joint CDF
x <- rnorm(5000) ; y <- rnorm(5000)
plot3d(x, y, Co.LPM(0, sort(x), sort(y), x, y), col = "blue", xlab = "X", ylab = "Y",
zlab = "Probability", box = FALSE)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}

Viole, F. (2017) "Continuous CDFs and ANOVA with NNS"
\url{https://www.ssrn.com/abstract=3007373}
}
\author{
Fred Viole, OVVO Financial Systems
}
