% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nowcast.R
\name{NNS.nowcast}
\alias{NNS.nowcast}
\title{NNS Nowcast}
\usage{
NNS.nowcast(
  h = 12,
  additional.regressors = NULL,
  start.date = "2000-01-03",
  Quandl.key = NULL,
  status = TRUE,
  ncores = NULL
)
}
\arguments{
\item{h}{integer; \code{(h = 12)} (default) Number of periods to forecast. \code{(h = 0)} will return just the interpolated and extrapolated values.}

\item{additional.regressors}{character; \code{NULL} (default) add more regressors to the base model.  The format must utilize the Quandl exchange format as described in \url{https://docs.data.nasdaq.com/docs/data-organization}.  For example, the 10-year US Treasury yield using the St. Louis Federal Reserve data is \code{"FRED/DGS10"}.}

\item{start.date}{character; \code{"2000-01-03"} (default) Starting date for all data series download.}

\item{Quandl.key}{character; \code{NULL} (default) User provided \link{Quandl} API key WITH QUOTES.  If previously entered in the current environment via \code{Quandl::Quandl.api_key}, no further action required.}

\item{status}{logical; \code{TRUE} (default) Prints status update message in console.}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized subroutine \link{NNS.ARMA.optim}. If NULL (default), the number of cores to be used is equal to the number of cores of the machine - 1.}
}
\value{
Returns the following matrices of forecasted variables:
\itemize{
 \item{\code{"interpolated_and_extrapolated"}} Returns a \code{data.frame} of the linear interpolated and \link{NNS.ARMA} extrapolated values to replace \code{NA} values in the original \code{variables} argument.  This is required for working with variables containing different frequencies, e.g. where \code{NA} would be reported for intra-quarterly data when indexed with monthly periods.
 \item{\code{"relevant_variables"}} Returns the relevant variables from the dimension reduction step.

 \item{\code{"univariate"}} Returns the univariate \link{NNS.ARMA} forecasts.

 \item{\code{"multivariate"}} Returns the multi-variate \link{NNS.reg} forecasts.

 \item{\code{"ensemble"}} Returns the ensemble of both \code{"univariate"} and \code{"multivariate"} forecasts.
 }
}
\description{
Wrapper function for NNS nowcasting method using \link{NNS.VAR} as detailed in Viole (2020), \url{https://www.ssrn.com/abstract=3586658}.
}
\note{
\itemize{
\item This function requires an API key from Quandl.  Sign up via \url{https://data.nasdaq.com/}.
}
}
\examples{

 \dontrun{
 NNS.nowcast(h = 12)
 }

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}

Viole, F. (2019) "Multi-variate Time-Series Forecasting: Nonparametric Vector Autoregression Using NNS"
\url{https://www.ssrn.com/abstract=3489550}

Viole, F. (2020) "NOWCASTING with NNS"
\url{https://www.ssrn.com/abstract=3589816}
}
\author{
Fred Viole, OVVO Financial Systems
}
