% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNS_VAR.R
\name{NNS.VAR}
\alias{NNS.VAR}
\title{NNS VAR}
\usage{
NNS.VAR(variables, h, tau = 0, obj.fn = expression(sum((predicted -
  actual)^2)), objective = "min", epochs = 100, status = TRUE,
  ncores = NULL)
}
\arguments{
\item{variables}{a numeric matrix or data.frame of contemporaneous time-series to forecast.}

\item{h}{integer; 1 (default) Number of periods to forecast.}

\item{tau}{integer; 0 (default) Number of lagged observations to consider for the time-series data.}

\item{obj.fn}{expression;
\code{expression(sum((predicted - actual)^2))} (default) Sum of squared errors is the default objective function.  Any \code{expression()} using the specific terms \code{predicted} and \code{actual} can be used.}

\item{objective}{options: ("min", "max") \code{"min"} (default) Select whether to minimize or maximize the objective function \code{obj.fn}.}

\item{epochs}{integer; \code{100} (default) Total number of feature combinations to run.}

\item{status}{logical; \code{TRUE} (default) Prints status update message in console.}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized subroutine \link{NNS.reg}. If NULL (default), the number of cores to be used is equal to half the number of cores of the machine - 1.}
}
\value{
Returns the following matrices of forecasted variables:
\itemize{
 \item{\code{"univariate"}} Returns the univariate \link{NNS.ARMA} forecasts.

 \item{\code{"multivariate"}} Returns the multi-variate \link{NNS.reg} forecasts.

 \item{\code{"ensemble"}} Returns the ensemble of both \code{"univariate"} and \code{"multivariate"} forecasts.
 }
}
\description{
Nonparametric vector autoregressive model incorporating \link{NNS.ARMA} estimates of variables into \link{NNS.reg} for a multi-variate time-series forecast.
}
\examples{

 \dontrun{
 set.seed(123)
 x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
 A <- cbind(x = x, y = y, z = z)
 NNS.VAR(A, h = 12, tau = 4, status = TRUE)
 }

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}

Viole, F. (2019) "Multi-variate Time-Series Forecasting: Nonparametric Vector Autoregression Using NNS"
\url{https://ssrn.com/abstract=3489550}

Viole, F. (2019) "Forecasting Using NNS"
\url{https://ssrn.com/abstract=3382300}

Vinod, H. and Viole, F. (2017) "Nonparametric Regression Using Clusters"
\url{https://link.springer.com/article/10.1007/s10614-017-9713-5}

Vinod, H. and Viole, F. (2018) "Clustering and Curve Fitting by Line Segments"
\url{https://www.preprints.org/manuscript/201801.0090/v1}
}
\author{
Fred Viole, OVVO Financial Systems
}
