% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{NNS.reg}
\alias{NNS.reg}
\title{NNS Regression}
\usage{
NNS.reg(x, y, factor.2.dummy = TRUE, order = NULL, stn = 0.96,
  dim.red.method = NULL, tau = NULL, type = NULL, point.est = NULL,
  location = "top", return.values = TRUE, plot = TRUE,
  plot.regions = FALSE, residual.plot = TRUE, std.errors = FALSE,
  confidence.interval = NULL, threshold = 0, n.best = NULL,
  noise.reduction = "mean", dist = "L2", ncores = NULL,
  multivariate.call = FALSE)
}
\arguments{
\item{x}{a vector, matrix or data frame of variables of numeric or factor data types.}

\item{y}{a numeric or factor vector with compatible dimsensions to \code{x}.}

\item{factor.2.dummy}{logical; \code{TRUE} (default) Automatically augments variable matrix with numerical dummy variables based on the levels of factors.}

\item{order}{integer; Controls the number of partial moment quadrant means.  Users are encouraged to try different \code{(order = ...)} integer settings with \code{(noise.reduction = "off")}.  \code{(order = "max")} will force a limit condition perfect fit.}

\item{stn}{numeric [0, 1]; Signal to noise parameter, sets the threshold of \code{(NNS.dep)} which reduces \code{("order")} when \code{(order = NULL)}.  Defaults to 0.96 to ensure high dependence for higher \code{("order")} and endpoint determination.}

\item{dim.red.method}{options: ("cor", "NNS.dep", "NNS.caus", "all", NULL) method for determining synthetic X* coefficients.  Selection of a method automatically engages the dimension reduction regression.  The default is \code{NULL} for full multivariate regression.  \code{(dim.red.method = "NNS.dep")} uses \link{NNS.dep} for nonlinear dependence weights, while \code{(dim.red.method = "NNS.caus")} uses \link{NNS.caus} for causal weights.  \code{(dim.red.method = "cor")} uses standard linear correlation for weights.  \code{(dim.red.method = "all")} averages all methods for further feature engineering.}

\item{tau}{options("ts", NULL); \code{NULL}(default) To be used in conjuction with \code{(dim.red.method = "NNS.caus")} or \code{(dim.red.method = "all")}.  If the regression is using time-series data, set \code{(tau = "ts")} for more accurate causal analysis.}

\item{type}{\code{NULL} (default).  To perform a classification, set to \code{(type = "CLASS")}.}

\item{point.est}{a numeric or factor vector with compatible dimsensions to \code{x}.  Returns the fitted value \code{y.hat} for any value of \code{x}.}

\item{location}{Sets the legend location within the plot, per the \code{x} and \code{y} co-ordinates used in base graphics \link{legend}.}

\item{return.values}{logical; \code{TRUE} (default), set to \code{FALSE} in order to only display a regression plot and call values as needed.}

\item{plot}{logical; \code{TRUE} (default) To plot regression.}

\item{plot.regions}{logical; \code{FALSE} (default).  Generates 3d regions associated with each regression point for multivariate regressions.  Note, adds significant time to routine.}

\item{residual.plot}{logical; \code{TRUE} (default) To plot \code{y.hat} and \code{Y}.}

\item{std.errors}{logical; \code{FALSE} (default) To provide standard errors of each linear segment in the \code{"Fitted.xy"} output.}

\item{confidence.interval}{numeric [0, 1]; \code{NULL} (default) Plots the associated confidence interval with the estimate and reports the standard error for each individual segment.}

\item{threshold}{numeric [0, 1]; \code{(threshold = 0)} (default) Sets the threshold for dimension reduction of independent variables when \code{(dim.red.method)} is not \code{NULL}.}

\item{n.best}{integer; \code{NULL} (default) Sets the number of nearest regression points to use in weighting for multivariate regression at \code{sqrt(# of regressors)}.  \code{(n.best = "all")} will select and weight all generated regression points.  Analogous to \code{k} in a
\code{k Nearest Neighbors} algorithm.  Different values of \code{n.best} are tested using cross-validation in \link{NNS.stack}.}

\item{noise.reduction}{the method of determing regression points options: ("mean", "median", "mode", "off"); In low signal:noise situations,\code{(noise.reduction = "mean")}  uses means for \link{NNS.dep} restricted partitions, \code{(noise.reduction = "median")}  uses medians instead of means for \link{NNS.dep} restricted partitions, while \code{(noise.reduction = "mode")}  uses modes instead of means for \link{NNS.dep} restricted partitions.  \code{(noise.reduction = "off")}  allows for maximum possible fit with a specific \code{order}.}

\item{dist}{options:("L1", "L2") the method of distance calculation; Selects the distance calculation used. \code{dist = "L2"} (default) selects the Euclidean distance and \code{(dist = "L1")} seclects the Manhattan distance.}

\item{ncores}{integer; value specifying the number of cores to be used in the parallelized  procedure. If NULL (default), the number of cores to be used is equal to the number of cores of the machine - 1.}

\item{multivariate.call}{Internal parameter for multivariate regressions.}
}
\value{
UNIVARIATE REGRESSION RETURNS THE FOLLOWING VALUES:
\itemize{
 \item{\code{"R2"}} provides the goodness of fit;

 \item{\code{"SE"}} returns the overall standard error of the estimate between \code{y} and \code{y.hat};

 \item{\code{"Prediction.Accuracy"}} returns the correct rounded \code{"Point.est"} used in classifications versus the categorical \code{y};

 \item{\code{"derivative"}} for the coefficient of the \code{x} and its applicable range;

 \item{\code{"Point.est"}} for the predicted value generated;

 \item{\code{"regression.points"}} provides the points used in the regression equation for the given order of partitions;

 \item{\code{"Fitted.xy"}} returns a \link{data.table} of \code{x}, \code{y}, \code{y.hat}, \code{resid}, \code{NNS.ID}, \code{gradient};
}


MULTIVARIATE REGRESSION RETURNS THE FOLLOWING VALUES:
\itemize{
 \item{\code{"R2"}} provides the goodness of fit;

 \item{\code{"equation"}} returns the numerator of the synthetic X* dimension reduction equation as a \link{data.table} consisting of regressor and its coefficient.  Denominator is simply the length of all coefficients > 0, returned in last row of \code{equation} data.table.

 \item{\code{"x.star"}} returns the synthetic X* as a vector;

 \item{\code{"rhs.partitions"}} returns the partition points for each regressor \code{x};

 \item{\code{"RPM"}} provides the Regression Point Matrix, the points for each \code{x} used in the regression equation for the given order of partitions;

 \item{\code{"Point.est"}} returns the predicted value generated;

 \item{\code{"Fitted.xy"}} returns a \link{data.table} of \code{x},\code{y}, \code{y.hat}, \code{gradient}, and \code{NNS.ID}.
}
}
\description{
Generates a nonlinear regression based on partial moment quadrant means.
}
\note{
Please ensure \code{point.est} is of compatible dimensions to \code{x}, error message will ensue if not compatible.
}
\examples{
\dontrun{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.reg(x, y)

## Manual {order} selection
NNS.reg(x, y, order = 2)

## Maximum {order} selection
NNS.reg(x, y, order = "max")

## x-only paritioning (Univariate only)
NNS.reg(x, y, type = "XONLY")

## For Multiple Regression:
x <- cbind(rnorm(100), rnorm(100), rnorm(100)) ; y <- rnorm(100)
NNS.reg(x, y, point.est = c(.25, .5, .75))

## For Multiple Regression based on Synthetic X* (Dimension Reduction):
x <- cbind(rnorm(100), rnorm(100), rnorm(100)) ; y <- rnorm(100)
NNS.reg(x, y, point.est = c(.25, .5, .75), dim.red.method = "cor")

## IRIS dataset examples:
# Dimension Reduction:
NNS.reg(iris[,1:4], iris[,5], dim.red.method = "cor", order = 5)

# Dimension Reduction using causal weights:
NNS.reg(iris[,1:4], iris[,5], dim.red.method = "NNS.caus", order = 5)

# Multiple Regression:
NNS.reg(iris[,1:4], iris[,5], order = 2, noise.reduction = "off")

# Classification:
NNS.reg(iris[,1:4], iris[,5], point.est = iris[1:10, 1:4], type = "CLASS")$Point.est

## To call fitted values:
x <- rnorm(100) ; y <- rnorm(100)
NNS.reg(x, y)$Fitted

## To call partial derivative (univariate regression only):
NNS.reg(x, y)$derivative}

}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}

Vinod, H. and Viole, F. (2017) "Nonparametric Regression Using Clusters"
\url{https://link.springer.com/article/10.1007/s10614-017-9713-5}
}
\author{
Fred Viole, OVVO Financial Systems
}
