% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.R
\name{NNS.ANOVA}
\alias{NNS.ANOVA}
\title{NNS ANOVA}
\usage{
NNS.ANOVA(control, treatment, confidence.interval = 0.95, pairwise = FALSE,
  plot = TRUE, binary = TRUE, extend = NULL)
}
\arguments{
\item{control}{a numeric vector, matrix or data frame.}

\item{treatment}{\code{NULL} (default) a numeric vector, matrix or data frame.}

\item{confidence.interval}{numeric [0,1]; The confidence interval surrounding the control mean when \code{(binary=TRUE)}.  Defaults to \code{(confidence.interval=0.95)}.}

\item{pairwise}{logical; \code{FALSE} (defualt) Returns pairwise certainty tests when set to \code{pairwise=TRUE}.}

\item{plot}{logical; \code{TRUE} (default) Returns the boxplot of all variables along with grand mean identification.  When \code{(binary=TRUE)}, returns the boxplot of both variables along with grand mean identification and confidence interval thereof.}

\item{binary}{logical; \code{TRUE} (default) Selects binary analysis between a control and treatment variable.}

\item{extend}{options:("yes", NULL): \code{NULL} (default) Sets the \code{"extendInt"} argument from \link{uniroot}.}
}
\value{
For \code{(binary=FALSE)} returns the degree certainty the difference in sample means is zero [0,1].

For \code{(binary=TRUE)} returns \code{"Control Mean"}, \code{"Treatment Mean"}, \code{"Grand Mean"}, \code{"Control CDF"}, \code{"Treatment CDF"}, the certainty of the same population statistic \code{"Certainty"}, the effect size of the treatment for a specified confidence interval with \code{"Lower Bound Effect"} and \code{"Upper Bound Effect"}.
}
\description{
Analysis of variance (ANOVA) based on lower partial moment CDFs for multiple variables.  Returns a degree of certainty the difference in sample means is zero, not a p-value.
}
\note{
If endpoint error is generated, set \code{(extend="yes")}.
}
\examples{
### Binary analysis and effect size
set.seed(123)
x<- rnorm(100); y<- rnorm(100)
NNS.ANOVA(control=x,treatment=y)

### Two variable analysis with no control variable
A<- cbind(x,y)
NNS.ANOVA(A)

### Multiple variable analysis with no control variable
set.seed(123)
x<- rnorm(100); y<- rnorm(100); z<- rnorm(100)
A<- cbind(x,y,z)
NNS.ANOVA(A)
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\author{
Fred Viole, OVVO Financial Systems
}
\keyword{ANOVA,}
\keyword{effect}
\keyword{size}
