% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Causation.R
\name{NNS.caus}
\alias{NNS.caus}
\title{NNS Causation}
\usage{
NNS.caus(x, y, tau, plot = FALSE)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{tau}{integer; Number of lagged observations to consider.}

\item{plot}{logical; \code{FALSE} (default) Plots the raw variables, tau normalized, and cross-normalized variables.}
}
\value{
Returns the directional causation and quantity of association.
}
\description{
Returns the causality from observational data between two variables
}
\examples{
## x clearly causes y...
set.seed(123)
x<-rnorm(100); y<-x^2
NNS.caus(x,y,1)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{causation}

