% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Seasonality_Test.R
\name{NNS.seas}
\alias{NNS.seas}
\title{NNS Seasonality Test}
\usage{
NNS.seas(variable)
}
\arguments{
\item{variable}{Variable}
}
\value{
Returns a matrix of all periods exhibiting less coefficient of variance than the variable with \code{"all.periods"}; and the single period exhibiting the least coefficient of variance versus the variable with \code{"best.period"}.
}
\description{
Seasonality test based on the coefficient of variance for the variable and lagged component series.  A result of 1 signifies no seasonality present.
}
\examples{
set.seed(123)
x<-rnorm(100)
## To call strongest period based on coefficient of variance
NNS.seas(x)$best.period
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}

