% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dependence.R
\name{VN.dep}
\alias{VN.dep}
\title{VN Dependence}
\usage{
VN.dep(x, y, order = 2, degree = NULL, print.map = FALSE)
}
\arguments{
\item{x}{Variable 1}

\item{y}{Variable 2}

\item{order}{Controls the level of quadrant partitioning.  Defualts to \code{order=2}.  Errors can generally be rectified by setting \code{order=1}.}

\item{degree}{Defaults to NULL to allow number of observations to be \code{degree} determinant.}

\item{print.map}{Plots quadrant means.  Defaults to FALSE.}
}
\value{
Returns the \code{"Correlation"} and \code{"Dependence"}
}
\description{
Returns the dependence between two variables based on higher order partial moment correlations measured by frequency or area.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
VN.dep(x,y)
}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{correlation}
\keyword{dependence,}

