% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression.R
\name{VN.reg}
\alias{VN.reg}
\title{VN Regression}
\usage{
VN.reg(x, y, order = NULL, s.t.n = 0.9, type = NULL, point.est = NULL,
  location = "top", return.values = TRUE, plot = TRUE,
  residual.plot = TRUE, threshold = 0, dep.order = NULL, n.best = NULL)
}
\arguments{
\item{x}{Independent Variable(s)}

\item{y}{Dependent Variable}

\item{order}{Controls the number of partial moment quadrant means.  Users are encouraged to try different \code{order=} settings.  \code{order='max'} will use maximum suggested possible order based on number of observations.}

\item{s.t.n}{Signal to noise parameter, sets the threshold of \code{VN.dep} which reduces \code{"order"} when \code{order=NULL}.  Defaults to 0.9 to ensure high dependence for higher \code{"order"} and endpoint determination.}

\item{type}{To perform logistic regression, set to \code{type = "LOGIT"}.  To perform a classification, set to \code{type = "CLASS"}.  Defualts to NULL.}

\item{point.est}{Returns the fitted value for any value of the independent variable.  Use a vector of values for independent varaiables to return the multiple regression fitted value.}

\item{location}{Sets the legend location within the plot}

\item{return.values}{Defaults to TRUE, set to FALSE in order to avoid displaing all \code{VALUE} outputs.}

\item{plot}{To plot regression or not.  Defaults to TRUE.}

\item{residual.plot}{To plot the fitted values of Y and Y.  Defaults to TRUE.}

\item{threshold}{Sets the correlation threshold for independent variables.  Defaults to 0.}

\item{dep.order}{Sets the internal order for \link{VN.dep}.  Categorical variables typically require \code{dep.order=1}.  Error message will alert user if this is the case.}

\item{n.best}{Sets the number of nearest regression points to use in kernel weighting for multivariate regression.  Defaults to number of independent variables.}
}
\value{
UNIVARIATE regression returns the values: \code{"Fitted"} for a data frame of IV and fitted values; \code{"derivative"} for the coefficient of the IV and its applicable range; \code{"Point"} returns the IV point(s) being evaluated; \code{"Point.est"} for the predicted value generated; \code{"regression.points"} provides the points used in the regression equation for the given order of partitions; \code{"R2"} provides the goodness of fit.

MULTIVARIATE regression returns the values: \code{"Fitted"} for only the fitted values of the DV; \code{"regression.points"} provides the points for each IV used in the regression equation for the given order of partitions; \code{"rhs.partitions"} returns the partition points for each IV; \code{"partition"} returns the DV, quadrant assigned to the observation and fitted value; \code{"Point"} returns the IV point(s) being evaluated; \code{"Point.est"} returns the predicted value generated; \code{"equation"} returns the synthetic X* dimension reduction equation.
}
\description{
Generates a nonlinear regression based on partial moment quadrant means.
}
\examples{
set.seed(123)
x<-rnorm(100); y<-rnorm(100)
VN.reg(x,y)

## Manual {order} selection
VN.reg(x,y,order=2)

## Maximum {order} selection
VN.reg(x,y,order='max')

## x-only paritioning
VN.reg(x,y,type="XONLY")

## For Multiple Regression:
x<-cbind(rnorm(100),rnorm(100),rnorm(100)); y<-rnorm(100)
VN.reg(x,y,point.est=c(.25,.5,.75))

## For Multiple Regression based on Synthetic X* (Dimension Reduction):
x<-cbind(rnorm(100),rnorm(100),rnorm(100)); y<-rnorm(100)
VN.reg(x,y,point.est=c(.25,.5,.75),type="CLASS")

## IRIS dataset example:
#Dimension Reduction:
VN.reg(iris[,1:4],iris[,5],type="CLASS",order=5,dep.order=1)
#Multiple Regression:
VN.reg(iris[,1:4],iris[,5],order=2)

## To call fitted values:
VN.reg(x,y)$Fitted

## To call partial derivative (univariate regression only):
x<-rnorm(100); y<-rnorm(100)
VN.reg(x,y)$derivative

}
\author{
Fred Viole, OVVO Financial Systems
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{http://amzn.com/1490523995}
}
\keyword{nonlinear}
\keyword{regression}

