% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wl_referral_stats.R
\name{wl_referral_stats}
\alias{wl_referral_stats}
\title{Calculate some stats about referrals}
\usage{
wl_referral_stats(
  waiting_list,
  start_date = NULL,
  end_date = NULL,
  referral_index = 1
)
}
\arguments{
\item{waiting_list}{data.frame. A df of referral dates and removals}

\item{start_date}{date. The start date to calculate from}

\item{end_date}{date. The end date to calculate to}

\item{referral_index}{the column index of referrals}
}
\value{
A data.frame with the following summary statistics on
referrals/demand:

\describe{
\item{demand_weekly}{Numeric. Mean number of additions to the waiting list
per week.}
\item{demand_daily}{Numeric. Mean number of additions to the waiting list
per day.}
\item{demand_cov}{Numeric. Coefficient of variation in the time between
additions to the waiting list.}
\item{demand_count}{Numeric. Total demand over the full time period.}
}
}
\description{
Calculate some stats about referrals
}
\examples{
referrals <- c.Date("2024-01-01", "2024-01-04", "2024-01-10", "2024-01-16")
removals <- c.Date("2024-01-08", NA, NA, NA)
waiting_list <- data.frame("referral" = referrals, "removal" = removals)
referral_stats <- wl_referral_stats(waiting_list)

}
