% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OWcoef.R
\name{OWcoef}
\alias{OWcoef}
\title{Coefficients for W (emission inputs)}
\usage{
OWcoef(nhmmobj, plots = FALSE, outfile = NULL)
}
\arguments{
\item{nhmmobj}{an object created from the NHMM function}

\item{plots}{TRUE/FALSE- default is FALSE because the plot window can grow quite large depending on the number of sequences.}

\item{outfile}{a directory to put the .png plot}
}
\value{
params [K+A by J] by 6. There are six values returned: 0.025, 0.05, mean, 0.50 (median),
0.95, 0.975 quantiles from the iterations. (0.025, 0.975) are used to construct 95% probability intervals (PIs),
likewise (0.05, 0.95) can be used to construct 90% PIs.

output:  plot window can grow quite large depending on the number of sequences.
[K+A by J] panes.'

output: outputs statements of 90% and 95% significance of the intercept coefficients 
and each X input coefficients (if any of the J coefficients for a variable are significant then that
variable is deemed signficant.)
}
\description{
\code{OWcoef} calculates emission coefficient 0.025, 0.05, mean, 0.50 (median),
0.95, 0.975 quantiles from the iterations. These coeffiecients are 
used to determine the mixing weights of the mixture components of the emission distributions.
 There are K intercept coefficients and A input coeffients for each J.
}
\examples{
#thetas=OWcoef(my.nhmm, FALSE); 
#thetas[,,,,3]  #mean values
}
\keyword{coefficients}

