% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_funcs.R
\name{build.dist.struct}
\alias{build.dist.struct}
\title{An internal helper function that generates the data abstraction for the edge
weights of the main network structure.}
\usage{
build.dist.struct(
  z,
  X,
  distMat,
  exact = NULL,
  dist.type = "Mahalanobis",
  calip.option = "propensity",
  calip.cov = NULL,
  caliper = 0.2,
  verbose = FALSE
)
}
\arguments{
\item{z}{a vector of treatment and control indicators, 1 for treatment and 0
for control.}

\item{X}{a data frame or a numeric or logical matrix containing covariate
information for treated and control units. Its row count must be equal to
the length of z.}

\item{distMat}{a matrix of pair-wise distance specified by the user}

\item{exact}{an optional vector of the same length as z. If this argument is
specified, treated units will only be allowed to match to control units
that have equal values in the corresponding indices of the exact vector.
For example, to match patients within hospitals only, one could set exact
equal to a vector of hospital IDs for each patient.}

\item{dist.type}{one of ('propensity','user','none'). If ’propensity’ is
specified (the default option), the function estimates a propensity score
via logistic regression of z on X and imposes a propensity score caliper.
If ’user’ is specified, the user must provide a vector of values on which a
caliper will be enforced using the calip.cov argument. If ’none’ is
specified no caliper is used.}

\item{calip.option}{a character indicating the type of caliper used}

\item{calip.cov}{see calip.option.}

\item{caliper}{a numeric value that gives the size of the caliper when the
user specifies the calip.option argument as ’propensity’ or ’calip.cov’.}

\item{verbose}{a boolean value whether to print(cat) debug information.
Default: FALSE}
}
\value{
a distance structure used for constructing the main network flow
problem
}
\description{
An internal helper function that generates the data abstraction for the edge
weights of the main network structure.
}
