% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiasCorrection.R
\name{Bias_Correc_VAR}
\alias{Bias_Correc_VAR}
\title{Estimates an unbiased VAR(1) using stochastic approximation (Bauer, Rudebusch and Wu, 2012)}
\usage{
Bias_Correc_VAR(
  ModelType,
  BRWinputs,
  RiskFactors,
  Economies,
  FactorLabels,
  GVARinputs = NULL,
  JLLinputs = NULL,
  verbose = TRUE
)
}
\arguments{
\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{BRWinputs}{list. Contains the necessary inputs for the BRW model estimation:
\enumerate{
  \item \code{Cent_Measure}: "Mean" or "Median" (unbiased estimation type)
  \item \code{gamma}: Numeric. Adjustment parameter between 0 and 1. Default is 0.5.
  \item \code{N_iter}: Integer. Number of iterations for the stochastic approximation algorithm after burn-in. Default is 5000.
  \item \code{N_burn}: Integer. Number of burn-in iterations. Default is 15% of \code{N_iter}.
  \item \code{B}: Integer. Number of bootstrap samples per iteration for calculating the noisy measure of the biased estimator's mean or median. Default is 50.
  \item \code{check}: Logical. Indicates whether to perform a closeness check. Default is TRUE.
  \item \code{B_check}: Integer. Number of bootstrap samples for the closeness check. Default is 100000.
  \item \code{Eigen_rest}: Numeric. Restriction on the largest eigenvalue under the P-measure. Default is 1.
}}

\item{RiskFactors}{numeric matrix (\code{Td x K}). Time series of risk factors.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{FactorLabels}{list. Labels for all variables in the model.}

\item{GVARinputs}{list. Inputs for GVAR model estimation (see \code{\link{GVAR}}). Default is NULL.}

\item{JLLinputs}{list. Inputs for JLL model estimation (see \code{\link{JLL}}). Default is NULL.}

\item{verbose}{logical. Flag controlling function messaging. Default TRUE.}
}
\value{
Bias-corrected VAR parameters based on the framework of Bauer, Rudebusch and Wu (2012). The list contains:
\enumerate{
  \item \code{KOZ_BC}: estimated intercept (K x 1);
  \item \code{K1Z_BC}: estimated feedback matrix (K x K);
  \item \code{SSZ_BC}: estimated variance-covariance matrix (K x K);
  \item \code{dist}: root mean square distance (scalar);
}
}
\description{
Estimates an unbiased VAR(1) using stochastic approximation (Bauer, Rudebusch and Wu, 2012)
}
\section{General Notation}{

\itemize{
  \item \code{Td} denotes the model time series dimension.
  \item \code{C} number of countries in the system.
  \item \code{K} denotes the total number of risk factors.
}
}

\examples{
\donttest{
data(RiskFacFull)
Factors <- t(RiskFacFull[1:7, ])

BRWinputs <- list(
  Cent_Measure = "Mean", gamma = 0.4, N_iter = 1000, N_burn = 100,
  B = 10, check = 1, B_check = 5000
)

Economies <- "China"
N <- 3
ModelType <- "JPS original"
FactorLabels <- NULL

BRWpara <- Bias_Correc_VAR(ModelType, BRWinputs, Factors, Economies, FactorLabels, verbose = FALSE)
}

}
\references{
Bauer, Rudebusch and, Wu (2012). "Correcting Estimation Bias in Dynamic Term Structure Models" \cr
This function offers an independent R implementation that is informed
by the conceptual framework outlined in Bauer, Rudebusch and Wu (2012), but adapted to the
present modeling context. Related Matlab routines are available on Cynthia Wu's
website (https://sites.google.com/view/jingcynthiawu/).
}
