% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiasCorrection.R
\name{m_var}
\alias{m_var}
\title{Find mean or median of OLS when DGP is VAR(1)}
\usage{
m_var(
  theta,
  M,
  RiskFactors,
  N,
  GVARinputs,
  JLLinputs,
  FactorLabels,
  Economies,
  ModelType,
  flag_mean = TRUE
)
}
\arguments{
\item{theta}{parameters from the feedback matrix in vector form}

\item{M}{number of Monte Carlo replications}

\item{RiskFactors}{time series of the risk factors (T x F)}

\item{N}{number of country-specific spanned factors (scalar)}

\item{GVARinputs}{inputs used in the estimation of the GVAR-based models (see "GVAR" function). Default is set to NULL}

\item{JLLinputs}{inputs used in the estimation of the JLL-based models (see "JLL" function). Default is set to NULL}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{flag_mean}{flag whether mean- (TRUE) or median- (FALSE) unbiased estimation is desired. Default is set to TRUE}
}
\description{
Find mean or median of OLS when DGP is VAR(1)
}
\references{
Bauer, Rudebusch and, Wu (2012). "Correcting Estimation Bias in Dynamic Term Structure Models". \cr
This function is similar to the "m_var" Matlab function available at Cynthia Wu's website
(https://sites.google.com/view/jingcynthiawu/).
}
\keyword{internal}
