% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PsySimulate.R
\name{PsySimulate}
\alias{PsySimulate}
\title{Simulate psychophysical data}
\usage{
PsySimulate(fixeff = c(-7, 0.0875), raneff = c(2.4, -0.002, 2e-06),
  nsubjects = 8, pps = 9, ntrials = 40, xint = c(40, 120),
  constant = F)
}
\arguments{
\item{fixeff}{Array of fixed effects. First item is the intercept, second
item is the slope.}

\item{raneff}{Array of random effects. First item is the intercept, second
item is the covariance, third item is the slope.}

\item{nsubjects}{Number of subjects to simulate data for. Default is 8.}

\item{pps}{Number of stimulus levels. Default is 9.}

\item{ntrials}{Number of trials for each stimulus level. Default is 40.}

\item{xint}{Range of the stimulus interval. Default is c(40,120)}

\item{constant}{If set to FALSE, stimulus levels are randomly generated,
uniformly distributed values within the selected interval.
If constant = TRUE, the X interval is divided in  intervals of constant
length. Default is FALSE.}
}
\value{
The simulated dataset
}
\description{
Given the arrays of fixed and random effects, as well as the covariance,
and the characteristic of the simulated experiment (i.e., ) the function
simulates a dataset in which for each subject the following information is
provided: the slope and intercept value of the psychometric function, and
the simulated responses to the stimulus levels that fit that function.
}
\examples{
#simulate dataset (one subject)
datafr.S1 <- PsySimulate(nsubject = 1, constant = TRUE)

}
