% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmmMixedData.R
\docType{methods}
\name{plot,KmmMixedDataModel-method}
\alias{plot,KmmMixedDataModel-method}
\alias{plot-KmmMixedDataModel}
\title{Plotting of a class [\code{\linkS4class{KmmMixedDataModel}}]}
\usage{
\S4method{plot}{KmmMixedDataModel}(x, y, ...)
}
\arguments{
\item{x}{an object of class [\code{\linkS4class{KmmMixedDataModel}}]}

\item{y}{a vector listing the data sets you want to disply}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plotting data from a [\code{\linkS4class{KmmMixedDataModel}}] object
using the estimated parameters and partition.
}
\examples{
\donttest{
## The bullsEye data set
data(bullsEye)
data(bullsEye.cat)
## with default values
ldata  = list(bullsEye, bullsEye.cat)
modelcont <- list(modelName="kmm_pk_s", dim = 10, kernelName="Gaussian")
modelcat  <- list(modelName="kmm_pk_s", dim = 20, kernelName="Hamming", kernelParameters = c(0.6))
lmodels = list( modelcont, modelcat)

model <- kmmMixedData(ldata, lmodels, nbCluster=2:5, strategy = clusterFastStrategy())
# plot only the first continuous data set
plot(model, y=c(1))
  }

}
\seealso{
\code{\link{plot}}
}
