% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterPoisson.R
\name{clusterPoisson}
\alias{clusterPoisson}
\title{Create an instance of the [\code{\linkS4class{ClusterPoisson}}] class}
\usage{
clusterPoisson(
  data,
  nbCluster = 2,
  models = clusterPoissonNames(),
  strategy = clusterStrategy(),
  criterion = "ICL",
  nbCore = 1
)
}
\arguments{
\item{data}{a data.frame or matrix containing the data. Rows correspond to observations
and columns correspond to variables. data will be coerced as an integer matrix.
If data set contains NA values, they will be estimated during the estimation process.}

\item{nbCluster}{[\code{\link{vector}}] listing the number of clusters to test.}

\item{models}{[\code{\link{vector}}] of model names to run. By default all
poisson models are estimated.  All the model names are given by
the method [\code{\link{clusterPoissonNames}}].}

\item{strategy}{a [\code{\linkS4class{ClusterStrategy}}] object containing
the strategy to run. [\code{\link{clusterStrategy}}]() method by default.}

\item{criterion}{character defining the criterion to select the best model.
The best model is the one with the lowest criterion value.
Possible values: "BIC", "AIC", "ICL", "ML". Default is "ICL".}

\item{nbCore}{integer defining the number of processor to use (default is 1, 0 for all).}
}
\value{
An instance of the [\code{\linkS4class{ClusterPoisson}}] class.
}
\description{
This function computes the optimal poisson mixture model according
to the [\code{criterion}] among the list of model given in [\code{models}]
and the number of clusters given in [\code{nbCluster}], using the strategy
specified in [\code{strategy}].
}
\examples{
## A quantitative example with the DebTrivedi data set.
data(DebTrivedi)
dt <- DebTrivedi[1:500, c(1, 6,8, 15)]

model <- clusterPoisson( data=dt, nbCluster=2
                       , models=clusterPoissonNames(prop = "equal")
                       , strategy = clusterFastStrategy())

## use graphics functions
\donttest{
plot(model)
}

## get summary
summary(model)
\donttest{
## print model (a very detailed output)
print(model)
}
## get estimated missing values
missingValues(model)

}
\author{
Serge Iovleff
}
