% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmm.R
\docType{class}
\name{KmmModel}
\alias{KmmModel}
\alias{KmmModel-class}
\title{Definition of the [\code{\linkS4class{KmmModel}}] class}
\description{
This class defines a Kernel mixture Model (KMM).
}
\details{
This class inherits from the [\code{\linkS4class{IClusterModel}}] virtual class.
A KMM is a mixture model of the form:
\deqn{
  f({x}|\boldsymbol{\theta})
  =\sum_{k=1}^K p_k \prod_{j=1}^d \phi(x_j;\sigma^2_{k})
   \quad x \in {R}^d.
}
Some constraints can be added to the variances in order to reduce the number
of parameters.
}
\section{Slots}{

\describe{
\item{\code{component}}{A [\code{\linkS4class{KmmComponent}}] with the
dimension and standard deviation of the kernel mixture model.}
}}

\examples{
getSlots("KmmModel")
data(bullsEye)
new("KmmModel", data=bullsEye)

}
\seealso{
[\code{\linkS4class{IClusterModel}}] class
}
\author{
Serge Iovleff
}
