% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LearnAlgo.R
\name{learnAlgo}
\alias{learnAlgo}
\title{Create an instance of the [\code{\linkS4class{LearnAlgo}}] class}
\usage{
learnAlgo(algo = "Simul", nbIteration = 200, epsilon = 1e-07)
}
\arguments{
\item{algo}{character string with the estimation algorithm.
Possible values are "Simul", "Impute". Default value is "Simul".}

\item{nbIteration}{Integer defining the maximal number of iterations. Default value is 200.}

\item{epsilon}{Real defining the epsilon value for the algorithm. Not used
by the "Simul" algorithm. Default value is 1.e-7.}
}
\value{
a [\code{\linkS4class{LearnAlgo}}] object
}
\description{
There is two algorithms and two stopping rules possibles for a learning
algorithm.
\itemize{
       \item Algorithms:
          \itemize{
              \item \code{Impute} {Impute the missing values during the iterations}
              \item \code{Simul} {Simulate the missing values during the iterations}
          }
       \item Stopping rules:
          \itemize{
              \item \code{nbIteration} {Set the maximum number of iterations.}
              \item \code{epsilon} {Set relative increase of the log-likelihood criterion.}
          }
       \item Default values are \eqn{200} \code{nbIteration} of \code{Simul}.
}
The \code{epsilon} value is not used when the algorithm is "Simul". It is worth noting
that if there is no missing values, the method should be "Impute" and nbIteration
should be set to 1!
}
\examples{
learnAlgo()
learnAlgo(algo="simul", nbIteration=50)
learnAlgo(algo="impute", epsilon = 1e-06)

}
\author{
Serge Iovleff
}
