% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterModelNames.R
\name{clusterCategoricalNames}
\alias{clusterCategoricalNames}
\alias{clusterValidCategoricalNames}
\title{Create a vector of Categorical mixture model names.}
\usage{
clusterCategoricalNames(prop = "all", probabilities = "all")

clusterValidCategoricalNames(names)
}
\arguments{
\item{prop}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{probabilities}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{names}{a vector of character}
}
\value{
A vector of character with the model names.
}
\description{
In a Categorical mixture model, we can build 4 models:
\enumerate{
 \item {The proportions can be equal or free.}
 \item {The probabilities can be equal or free for all the variables.}
}

check if a vector of Categorical mixture model name is correct.
}
\details{
The model names are summarized in the following array:
\tabular{lll}{
 Model Name         \tab Proportions \tab Probabilities between variables  \cr
 categorical_p_pjk  \tab Equal       \tab Free                             \cr
 categorical_p_pk   \tab Equal       \tab Equal                            \cr
 categorical_pk_pjk \tab Free        \tab Free                             \cr
 categorical_pk_pk  \tab Free        \tab Equal                            \cr
}
}
\examples{
clusterCategoricalNames()
clusterCategoricalNames("all", "equal") # same as c( "categorical_pk_pk", "categorical_p_pk")

}
