% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClusterAlgo.R, R/ClusterCategorical.R, R/ClusterDiagGaussian.R, R/ClusterGamma.R, R/ClusterHeterogeneous.R, R/ClusterInit.R, R/ClusterKernel.R, R/ClusterPoisson.R, R/ClusterStrategy.R, R/IClusterModel.R
\docType{methods}
\name{initialize,ClusterAlgo-method}
\alias{initialize,ClusterAlgo-method}
\alias{initialize,ClusterCategorical-method}
\alias{initialize,ClusterCategoricalComponent-method}
\alias{initialize,ClusterDiagGaussian-method}
\alias{initialize,ClusterDiagGaussianComponent-method}
\alias{initialize,ClusterGamma-method}
\alias{initialize,ClusterGammaComponent-method}
\alias{initialize,ClusterHeterogeneous-method}
\alias{initialize,ClusterInit-method}
\alias{initialize,ClusterKernel-method}
\alias{initialize,ClusterKernelComponent-method}
\alias{initialize,ClusterPoisson-method}
\alias{initialize,ClusterPoissonComponent-method}
\alias{initialize,ClusterStrategy-method}
\alias{initialize,IClusterComponent-method}
\alias{initialize,IClusterModelBase-method}
\title{Initialize an instance of a MixAll S4 class.}
\usage{
\S4method{initialize}{ClusterAlgo}(.Object, algo, nbIteration, epsilon)

\S4method{initialize}{ClusterCategoricalComponent}(.Object, data = matrix(nrow
  = 0, ncol = 0), nbCluster = 2, modelName = "categorical_pk_pjk")

\S4method{initialize}{ClusterCategorical}(.Object, data = matrix(nrow = 0,
  ncol = 0), nbCluster = 2, modelName = "categorical_pk_pjk")

\S4method{initialize}{ClusterDiagGaussianComponent}(.Object,
  data = matrix(nrow = 0, ncol = 0), nbCluster = 2,
  modelName = "gaussian_pk_sjk")

\S4method{initialize}{ClusterDiagGaussian}(.Object, data = matrix(nrow = 0,
  ncol = 0), nbCluster = 2, modelName = "gaussian_pk_sjk")

\S4method{initialize}{ClusterGammaComponent}(.Object, data = matrix(nrow = 0,
  ncol = 0), nbCluster = 2, modelName = "gamma_pk_ajk_bjk")

\S4method{initialize}{ClusterGamma}(.Object, data = matrix(nrow = 0, ncol =
  0), nbCluster = 2, modelName = "gamma_pk_ajk_bjk")

\S4method{initialize}{ClusterHeterogeneous}(.Object, ldata = list(),
  nbCluster = 2)

\S4method{initialize}{ClusterInit}(.Object, method = "class", nbInit = 5,
  algo = clusterAlgo("EM", 20, 0))

\S4method{initialize}{ClusterKernelComponent}(.Object, data = matrix(nrow = 0,
  ncol = 0), dim = 10, nbCluster = 2, modelName = "kernelGaussian_pk_sk")

\S4method{initialize}{ClusterKernel}(.Object, data = matrix(nrow = 0, ncol =
  0), dim = 10, kernelName = "gaussian", kernelParameters = NULL,
  nbCluster = 2, modelName = "kernelGaussian_pk_sk")

\S4method{initialize}{ClusterPoissonComponent}(.Object, data = matrix(nrow =
  0, ncol = 0), nbCluster = 2, modelName = "poisson_pk_ljk")

\S4method{initialize}{ClusterPoisson}(.Object, data = matrix(nrow = 0, ncol =
  0), nbCluster = 2, modelName = "poisson_pk_ljk")

\S4method{initialize}{ClusterStrategy}(.Object, nbTry, nbShortRun, initMethod,
  shortAlgo, longAlgo)

\S4method{initialize}{IClusterModelBase}(.Object, nbSample = 0,
  nbCluster = 0)

\S4method{initialize}{IClusterComponent}(.Object, data, modelName)
}
\description{
Initialization method of the [\code{\linkS4class{ClusterAlgo}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterCategoricalComponent}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterCategorical}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterDiagGaussianComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterDiagGaussian}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterGammaComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterGamma}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterHeterogeneous}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterInit}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterKernelComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterKernel}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterPoissonComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterPoisson}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterStrategy}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{IClusterModelBase}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{IClusterComponent}}] class.
Used internally in the 'MixAll' package.
}
\keyword{internal}

