% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{comp.CVD_score}
\alias{comp.CVD_score}
\title{comp.CVD_score}
\usage{
comp.CVD_score(met, phen, betas, quiet = FALSE)
}
\arguments{
\item{met}{numeric data-frame with Nightingale-metabolomics}

\item{phen}{data-frame containing phenotypic information of the samples (specifically: sex, systolic_blood_pressure, current_smoking, diabetes, blood_pressure_lowering_med, lipidmed, totchol, and hdlchol)}

\item{betas}{The betas of the linear regression composing the CVD-score}

\item{quiet}{logical to suppress the messages in the console}
}
\value{
data-frame containing the value of the CVD-score on the uploaded data-set
}
\description{
Function to compute CVD-score made by Peter Wurtz et al. made by Deelen et al. on Nightingale metabolomics data-set.
}
\examples{
library(MiMIR)

#load the dataset
met <- synthetic_metabolic_dataset
phen<-synthetic_phenotypic_dataset
#Prepare the metabolic features fo the mortality score
CVDscore<-comp.CVD_score(met= met, phen=phen, betas=MiMIR::CVD_score_betas, quiet=TRUE)


}
\references{
This function is constructed to be able to apply the CVD-score as described in:
Wurtz,P. et al. (2015) Metabolite profiling and cardiovascular event risk: a prospective study of 3 population-based cohorts. Circulation, 131, 774-785, \url{doi:10.1161/CIRCULATIONAHA.114.013116}
}
\seealso{
prep_met_for_scores, CVD_score_betas, comp.T2D_Ahola_Olli, comp.mort_score
}
