% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric_graph.R
\name{graph_components}
\alias{graph_components}
\title{Connected components of metric graph}
\value{
Object of \code{\link[R6]{R6Class}} for creating metric graph components.
}
\description{
Class representing connected components of a metric graph.
}
\details{
A list of \code{metric_graph} objects (representing the different
connected components in the full graph) created from vertex and edge matrices,
or from an sp::SpatialLines object where each line is representing and edge.
For more details, see the vignette:
\code{vignette("metric_graph", package = "MetricGraph")}
}
\examples{
library(sp)
edge1 <- rbind(c(0, 0), c(1, 0))
edge2 <- rbind(c(1, 0), c(2, 0))
edge3 <- rbind(c(1, 1), c(2, 1))
edges <- list(edge1, edge2, edge3)

graphs <- graph_components$new(edges)
graphs$plot()
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{graphs}}{List of the graphs representing the connected components.}

\item{\code{n}}{The number of graphs.}

\item{\code{sizes}}{Number of vertices for each of the graphs.}

\item{\code{lengths}}{Total edge lengths for each of the graphs.
Create metric graphs for connected components}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-graph_components-new}{\code{graph_components$new()}}
\item \href{#method-graph_components-get_largest}{\code{graph_components$get_largest()}}
\item \href{#method-graph_components-plot}{\code{graph_components$plot()}}
\item \href{#method-graph_components-clone}{\code{graph_components$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph_components-new"></a>}}
\if{latex}{\out{\hypertarget{method-graph_components-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{graph_components$new(
  edges = NULL,
  V = NULL,
  E = NULL,
  by_length = TRUE,
  ...,
  lines = deprecated()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{edges}}{A list containing coordinates as \verb{m x 2} matrices (that is, of \code{matrix} type) or m x 2 data frames (\code{data.frame} type) of sequence of points connected by straightlines. Alternatively, you can also prove an object of type \code{SpatialLinesDataFrame} or \code{SpatialLines} (from \code{sp} package) or \code{MULTILINESTRING} (from \code{sf} package).}

\item{\code{V}}{n x 2 matrix with Euclidean coordinates of the n vertices.}

\item{\code{E}}{m x 2 matrix where each row represents an edge.}

\item{\code{by_length}}{Sort the components by total edge length? If \code{FALSE},
the components are sorted by the number of vertices.}

\item{\code{...}}{Additional arguments used when specifying the graphs}

\item{\code{lines}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{edges} instead.}

\item{\code{vertex_unit}}{The unit in which the vertices are specified. The options are 'degrees' (the great circle distance in km), 'km', 'm' and 'miles'. The default is \code{NULL}, which means no unit. However, if you set \code{length_unit}, you need to set \code{vertex_unit}.}

\item{\code{length_unit}}{The unit in which the lengths will be computed. The options are 'km', 'm' and 'miles'. The default is \code{vertex_unit}. Observe that if \code{vertex_unit} is \code{NULL}, \code{length_unit} can only be \code{NULL}.
If \code{vertex_unit} is 'degrees', then the default value for \code{length_unit} is 'km'.}

\item{\code{longlat}}{If TRUE, then it is assumed that the coordinates are given.
in Longitude/Latitude and that distances should be computed in meters. It takes precedence over
\code{vertex_unit} and \code{length_unit}, and is equivalent to \code{vertex_unit = 'degrees'} and \code{length_unit = 'm'}.}

\item{\code{tolerance}}{Vertices that are closer than this number are merged when
constructing the graph (default = 1e-10). If \code{longlat = TRUE}, the
tolerance is given in km.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{graph_components} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph_components-get_largest"></a>}}
\if{latex}{\out{\hypertarget{method-graph_components-get_largest}{}}}
\subsection{Method \code{get_largest()}}{
Returns the largest component in the graph.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{graph_components$get_largest()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \code{metric_graph} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph_components-plot"></a>}}
\if{latex}{\out{\hypertarget{method-graph_components-plot}{}}}
\subsection{Method \code{plot()}}{
Plots all components.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{graph_components$plot(edge_colors = NULL, vertex_colors = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{edge_colors}}{A 3 x nc matrix with RGB values for the edge colors to
be used when plotting each graph.}

\item{\code{vertex_colors}}{A 3 x nc matrix with RGB values for the edge colors to
be used when plotting each graph.}

\item{\code{...}}{Additional arguments for plotting the individual graphs.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{ggplot} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-graph_components-clone"></a>}}
\if{latex}{\out{\hypertarget{method-graph_components-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{graph_components$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
