# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' MVMRcML method with Data Perturbation
#'
#' This is the internal MVMRcML-BIC function of mr_mvcML.
#'
#' @param b_exp A m*L matrix of SNP effects on the exposure variable.
#' @param b_out A m*1 matrix of SNP effects on the outcome variable.
#' @param se_bx A m*L matrix of standard errors of \code{b_exp}.
#' @param Sig_inv_l A list of the inverse of m covariance matrices.
#' @param n The smallest sample size of the L+1 GWAS dataset.
#' @param K_vec Sets of candidate K's, the constraint parameter representing number of invalid IVs.
#' @param random_start Number of random start points, default is 1.
#' @param min_theta_range The lower bound of the uniform distribution for each initial value for theta generated from.
#' @param max_theta_range The upper bound of the uniform distribution for each initial value for theta generated from.
#' @param maxit Maximum number of iterations for each optimization, default is 100.
#' @param thres Threshold for convergence criterion.
#'
#' @import Rcpp
#' @import RcppArmadillo
#' @return A list
#' \describe{
#' \item{BIC_theta}{Estimated causal effect from MVMR-cML-BIC}
#' \item{BIC_invalid}{Invalid IVs selected by MVMR-cML-BIC}
#' \item{l_vec}{A vector of negative log-likelihood corresponding to each \code{K}.}
#' \item{K_vec}{A vector of candidate K's}
#' \item{theta_vec}{A matrix of causal parameter estimates, each column corresponds to a candidate \code{K}.}
#' \item{Conv_vec}{A vector of successful convergence indicators corresponding to each \code{K}.}
#' \item{Converge}{Indicator of successful convergence, 0 means success, 1 means failure.}
#' \item{BIC_vec}{Data perturbation with successful convergence}
#' \item{Khat}{The length of \code{BIC_invalid}.}
#' }
#'
#' @export
MVmr_cML <- function(b_exp, b_out, se_bx, Sig_inv_l, n, K_vec = as.numeric( c()), random_start = 1L, min_theta_range = -0.5, max_theta_range = 0.5, maxit = 100L, thres = 1e-4) {
    .Call('_MendelianRandomization_MVmr_cML', PACKAGE = 'MendelianRandomization', b_exp, b_out, se_bx, Sig_inv_l, n, K_vec, random_start, min_theta_range, max_theta_range, maxit, thres)
}

#' MVMRcML method with Data Perturbation
#'
#' This is the internal MVMRcML-DP function of mr_mvcML.
#'
#' @param b_exp A m*L matrix of SNP effects on the exposure variable.
#' @param b_out A m*1 matrix of SNP effects on the outcome variable.
#' @param se_bx A m*L matrix of standard errors of \code{b_exp}.
#' @param Sig_inv_l A list of the inverse of m covariance matrices.
#' @param n The smallest sample size of the L+1 GWAS dataset.
#' @param K_vec Sets of candidate K's, the constraint parameter representing number of invalid IVs.
#' @param random_start Number of random start points, default is 1.
#' @param num_pert Number of perturbation, default is 100.
#' @param min_theta_range The lower bound of the uniform distribution for each initial value for theta generated from.
#' @param max_theta_range The upper bound of the uniform distribution for each initial value for theta generated from.
#' @param maxit Maximum number of iterations for each optimization, default is 100.
#' @param thres Threshold for convergence criterion.
#'
#' @import Rcpp
#' @import RcppArmadillo
#' @return A list
#' \describe{
#' \item{BIC_theta}{Estimated causal effect from MVMR-cML-BIC}
#' \item{BIC_invalid}{Invalid IVs selected by MVMR-cML-BIC}
#' \item{BIC_DP_theta}{Estimated causal effect from MVMR-cML-DP }
#' \item{BIC_DP_se}{Estimate standard error for \code{BIC_DP_theta}}
#' \item{eff_DP_B}{Data perturbation with successful convergence}
#' \item{DP_ninvalid}{A vector of the number of selected invalid IVs by MVMRcML-BIC in each data perturbation.}
#' }
#'
#' @export
MVmr_cML_DP <- function(b_exp, b_out, se_bx, Sig_inv_l, n, K_vec = as.numeric( c()), random_start = 1L, num_pert = 100L, min_theta_range = -0.5, max_theta_range = 0.5, maxit = 100L, thres = 1e-4) {
    .Call('_MendelianRandomization_MVmr_cML_DP', PACKAGE = 'MendelianRandomization', b_exp, b_out, se_bx, Sig_inv_l, n, K_vec, random_start, num_pert, min_theta_range, max_theta_range, maxit, thres)
}

