% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel-to-matrices.R
\name{kern_to_cov}
\alias{kern_to_cov}
\title{Create covariance matrix from a kernel}
\usage{
kern_to_cov(input, kern = "SE", hp, deriv = NULL, input_2 = NULL)
}
\arguments{
\item{input}{A vector, matrix, data frame or tibble containing all inputs for
one individual. If a vector, the elements are used as reference, otherwise
, one column should be named 'Input' to indicate that it represents the
reference (e.g. 'Input' would contain the timestamps in time-series
applications). The other columns are considered as being covariates. If
no column is named 'Input', the first one is used by default.}

\item{kern}{A kernel function. Several popular kernels
(see \href{https://www.cs.toronto.edu/~duvenaud/cookbook/}{The Kernel
Cookbook}) are already implemented and can be selected within the
following list:
\itemize{
\item "SE": (default value) the Squared Exponential Kernel (also called
Radial Basis Function or Gaussian kernel),
\item "LIN": the Linear kernel,
\item "PERIO": the Periodic kernel,
\item "RQ": the Rational Quadratic kernel.
Compound kernels can be created as sums or products of the above kernels.
For combining kernels, simply provide a formula as a character string
where elements are separated by whitespaces (e.g. "SE + PERIO"). As the
elements are treated sequentially from the left to the right, the product
operator '*' shall always be used before the '+' operators (e.g.
'SE * LIN + RQ' is valid whereas 'RQ + SE * LIN' is  not).
}}

\item{hp}{A list, data frame or tibble containing the hyper-parameters used
in the kernel. The name of the elements (or columns) should correspond
exactly to those used in the kernel definition. If \code{hp} contains an
element or a column 'Noise', its value will be added on the diagonal of
the covariance matrix.}

\item{deriv}{A character, indicating according to which hyper-parameter the
derivative should be computed. If NULL (default), the function simply
returns the covariance matrix.}

\item{input_2}{(optional) A vector, matrix, data frame or tibble under the
same format as \code{input}. This argument should be used only when the
kernel needs to be evaluated between two different sets of inputs,
typically resulting in a non-square matrix.}
}
\value{
A covariance matrix, where elements are evaluations of the associated
kernel for each pair of reference inputs.
}
\description{
\code{kern_to_cov()} creates a covariance matrix between input values (that
could be either scalars or vectors) evaluated within a kernel function,
which is characterised by specified hyper-parameters. This matrix is
a finite-dimensional evaluation of the infinite-dimensional covariance
structure of a GP, defined thanks to this kernel.
}
\examples{
TRUE
}
\keyword{internal}
