% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateSpec.R
\name{CreateSpec}
\alias{CreateSpec}
\title{Model specification.}
\usage{
CreateSpec(
  variance.spec = list(model = c("sGARCH", "sGARCH")),
  distribution.spec = list(distribution = c("norm", "norm")),
  switch.spec = list(do.mix = FALSE, K = NULL),
  constraint.spec = list(fixed = list(), regime.const = NULL),
  prior = list(mean = list(), sd = list())
)
}
\arguments{
\item{variance.spec}{\code{list} with element \code{model}.
\code{model} is a \code{character} vector (of size K, number of regimes)
with the variance model specifications. Valid models  are  \code{"sARCH"}, \code{"sGARCH"},
\code{"eGARCH"}, \code{"gjrGARCH"}, and \code{"tGARCH"} (see *Details*).
Default: \code{model = c("sGARCH", "sGARCH")}.}

\item{distribution.spec}{\code{list} with element \code{distribution}.
\code{distribution} is a \code{character} vector (of size K)
of conditional distributions. Valid distributions are \code{"norm"}, \code{"snorm"},
\code{"std"}, \code{"sstd"}, \code{"ged"}, and \code{"sged"}  (see *Details*).
The vector must be of the same length as the models' vector in \code{variance.spec}.\cr
Default: \code{distribution = c("norm", "norm")}.}

\item{switch.spec}{\code{list} with element \code{do.mix} and \code{K}.\cr
 \code{do.mix} is a \code{logical} indicating if the specification is a mixture type.
If \code{do.mix = TRUE}, a Mixture of GARCH is created, while if \code{do.mix = FALSE},
a Markov-Switching GARCH is created (see *Details*). Default: \code{do.mix = FALSE}.\cr
\code{K} is a optional \code{numeric} scalar indicating the number of regime.
 In the case where a single regime is specified in \code{variance.spec} and \code{distribution.spec},
 this parameter allows to automatically expand this single regime to \code{K} similar
 regimes without the need to explicitly define them in \code{variance.spec}
 and \code{distribution.spec} (see *Examples*).}

\item{constraint.spec}{\code{list} with element \code{fixed} and \code{regime.const}.
Only one of \code{fixed} and \code{regime.const}
 can be set by the user as it is not allowed to set both at the same time. \cr
 \code{fixed} is a  \code{list} with \code{numeric} entries and named elements.
 This argument controls for fixed parameters defined by the user.  The names of the entries
in the \code{list}  have to coincide with the names of the model parameters.\cr
 For instance, if \code{contraint.spec  = list(fixed = list(beta_1 = 0))}, \code{beta_1}
 will be fixed to \code{0} during optimization. \cr
 \code{regime.const} is a \code{character} vector.
 This argument controls for the parameters which are set equal across regimes.
 The names of the entries in the \code{list}  have to coincide with the names of the model parameters
 minus the regime indicator.\cr
 For instance, if \code{contraint.spec  = list(regime.const = c("beta"))},
 all the parameters named \code{beta} will be the same in all regimes during optimization.\cr}

\item{prior}{\code{list} with element \code{mean} and \code{sd}. The element \code{mean} and \code{sd}
are \code{list}  with \code{numeric} and named elements that allow to adjust the prior mean and
standard deviation of the truncated Normal prior.
The names of the entries in the lists have to coincide with the names of the model parameters.\cr
For instance, if \code{prior = list(mean = list(beta_1 = 0.7), sd = list(beta_1 = 0.1))},
the prior mean of \code{beta_1} will be set to \code{0.7} while the prior standard
deviation will set to \code{0.1}.}
}
\value{
A list of class \code{MSGARCH_SPEC} with the following elements:\cr
\itemize{
\item \code{par0}: Vector (of size d) of default parameters.
\item \code{is.mix}: Logical indicating if the specification is a mixture.
\item \code{K}: Number of regimes.
\item \code{lower}: Vector (of size d) of lower parameters' bounds.
\item \code{upper}: Vector (of size d) of upper parameters' bounds.
\item \code{n.params}:  Vector (of size K) of the total number of parameters by
regime including distributions' parameters.
\item \code{n.params.vol}:  Vector (of size K) of the total number of parameters
by regime excluding distributions' parameters.
\item \code{label}: Vector (of size d) of parameters' labels.
\item \code{name}: Vector (of size K) of model specifications' names.
\item \code{func}: List of internally used \R functions.
\item \code{rcpp.func}: List of internally used \code{Rcpp} functions.
\item \code{fixed.pars}: List of user inputed fixed parameters.
\item \code{regime.const.pars}: Vector of user imputed parameter set equal across regimes.
\item \code{regime.fixed.pars}: Logical indicating if there is any fixed parameteter set by the user.
\item \code{regime.const.pars.bool}: Logical indicating if there is any parameteters
 equal across regime set by the user.
}
The \code{MSGARCH_SPEC} class has the following methods:
\itemize{
\item \code{simulate}: Simulation.
\item \code{\link{Volatility}}: In-sample conditional volatility.
\item \code{predict}: Forecast of the conditional volatility (and predictive distribution).
\item \code{\link{UncVol}}: Unconditional volatility.
\item \code{\link{PredPdf}}: Predictive density (pdf).
\item \code{\link{PIT}}: Probability Integral Transform.
\item \code{\link{Risk}}: Value-at-Risk and Expected-Shortfall.
\item \code{\link{State}}: State probabilities (smoothed, filtered, predictive, Viterbi).
\item \code{\link{FitML}}: Maximum Likelihood estimation.
\item \code{\link{FitMCMC}}: Bayesian estimation.
\item \code{print} and \code{summary}: Summary of the created specification.
}
}
\description{
Creates a model specification before fitting and
using the \pkg{MSGARCH} functionalities.
}
\details{
The Markov-Switching specification is based on the
Haas et al. (2004a) MSGARCH specification. It is a MSGARCH model that is separated
in K single-regime specifications  which are updated in parallel. Under the Haas et al. (2004a)
specification, the conditional variance is a function of past data and the current state.
The Mixture of GARCH option (\code{do.mix = TRUE}) is based on Haas et al. (2004b). A Mixture of GARCH is a mixture of distributions
where the variance process of each distribution is a single-regime process.\cr
 For the models, \code{"sARCH"} is the ARCH(1) model (Engle, 1982), \code{"sGARCH"} the GARCH(1,1) model
(Bollerslev, 1986), \code{"eGARCH"} the EGARCH(1,1) model (Nelson, 1991), \code{"gjrGARCH"}
the GJR(1,1) model (Glosten et al., 1993), and \code{"tGARCH"} the TGARCH(1,1) model (Zakoian, 1994).\cr
For the distributions, \code{"norm"} is the Normal distribution, \code{"std"} the
Student-t distribution, and \code{"ged"} the GED distribution.
Their skewed version, implemented via the Fernandez and & Steel (1998) transformation,
are \code{"snorm"}, \code{"sstd"} and \code{"sged"}.
Please see Ardia et al. (2019) for more details on the models and distributions.\cr
The user must choose between \code{fixed} or \code{regime.const} in \code{contraint.spec}
as both cannot be set at the same time. The \code{list} \code{fixed.pars}
will ensure that the chosen fixed parameters will be fixed during optimization according to
the values set by the user.
Thus only the non-fixed parameters are optimized. The vector \code{regime.const} will
ensure that the chosen parameters will be the same across regime during optimization.\cr
The \code{list} \code{mean} and \code{sd} in \code{prior} will adjust the prior mean and
prior standard deviation of the truncated Normal prior for MCMC
estimation via \code{\link{FitMCMC}} according to the inputed prior mean and standard deviation.
Those prior means and standard deviations that are not set will take on preset default values (a mean 
of zero and a variance of 1,000).
}
\examples{
# create a Markov-switching specification
# MS-GARCH(1,1)-GJR(1,1)-Student
spec <- CreateSpec(variance.spec = list(model = c("sGARCH","gjrGARCH")),
                   distribution.spec = list(distribution = c("std","std")),
                   switch.spec = list(do.mix = FALSE))
print(spec)

# create a 3-regime Markov-switching specification with the help of variable K
# MS(3)-GARCH(1,1)- Student
spec <- CreateSpec(variance.spec = list(model = c("sGARCH")),
                   distribution.spec = list(distribution = c("std")),
                   switch.spec = list(do.mix = FALSE, K = 3))
print(spec)

# create a mixture specification
# MIX-GARCH(1,1)-GJR(1,1)-Student
spec <- CreateSpec(variance.spec = list(model = c("sGARCH","gjrGARCH")),
                   distribution.spec = list(distribution = c("std","std")),
                   switch.spec = list(do.mix = TRUE))
print(spec)

# setting fixed parameter for the sGARCH beta parameter
# MS-GARCH(1,1)-GJR(1,1)-Student with beta_1 fixed to 0
spec <- CreateSpec(variance.spec = list(model = c("sGARCH","gjrGARCH")),
                   distribution.spec = list(distribution = c("std","std")),
                   switch.spec = list(do.mix = FALSE),
                   constraint.spec = list(fixed = list(beta_1 = 0)))
print(spec)

# setting restriction for the shape parameter of the Student-t across regimes
# MS-GARCH(1,1)-GJR(1,1)-Student with shape parameter constraint across regime
spec <- CreateSpec(variance.spec = list(model = c("sGARCH","gjrGARCH")),
                   distribution.spec = list(distribution = c("std","std")),
                   switch.spec = list(do.mix = FALSE),
                   constraint.spec = list(regime.const = c("nu")))
print(spec)

# setting custom parameter priors for the beta parameters
# MS-GARCH(1,1)-GJR(1,1)-Student with prior modification
spec <- CreateSpec(variance.spec = list(model = c("sGARCH","gjrGARCH")),
                   distribution.spec = list(distribution = c("std","std")),
                   switch.spec = list(do.mix = FALSE),
                   prior = list(mean = list(beta_1 = 0.9, beta_2 = 0.3),
                                sd = list(beta_1 = 0.05, beta_2 = 0.01)))
print(spec)
}
\references{
Ardia, D. Bluteau, K. Boudt, K. Catania, L. Trottier, D.-A. (2019).
Markov-switching GARCH models in \R: The \pkg{MSGARCH} package.
\emph{Journal of Statistical Software}, 91(4), 1-38.
\doi{10.18637/jss.v091.i04}

Engle, R. (1982).
Autoregressive conditional heteroscedasticity with estimates of the variance of United Kingdom inflation
\emph{Econometrica}, 50, 987-1008.

Bollerslev, T. (1986).
Generalized autoregressive conditional heteroskedasticity.
\emph{Journal of Econometrics}, 31, 307-327.
\doi{10.1016/0304-4076(86)90063-1}

Fernandez, C. & Steel, M. F. (1998).
On Bayesian modeling of fat tails and skewness.
\emph{Journal of the American Statistical Association}, 93, 359-371.
\doi{10.1080/01621459.1998.10474117}

Glosten, L. R. Jagannathan, R. & Runkle, D. E. (1993).
On the relation between the expected value and the volatility of the nominal excess return on stocks.
\emph{Journal of Finance}, 48, 1779-1801.
\doi{10.1111/j.1540-6261.1993.tb05128.x}

Haas, M. Mittnik, S. & Paolella, M. S. (2004a).
A new approach to Markov-switching GARCH models.
\emph{Journal of Financial Econometrics}, 2, 493-530.
\doi{10.1093/jjfinec/nbh020}

Haas, M. Mittnik, S. & Paolella, M. S. (2004b).
Mixed normal conditional heteroskedasticity.
\emph{Journal of Financial Econometrics}, 2, 211-250.
\doi{10.1093/jjfinec/nbh009}

Nelson, D. B. (1991).
Conditional heteroskedasticity in asset returns: A new approach.
\emph{Econometrica}, 59, 347-370.

Zakoian, J.-M. (1994).
Threshold heteroskedastic models.
\emph{Journal of Economic Dynamics and Control}, 18, 931-955.
\doi{10.1016/0165-1889(94)90039-6}
}
