% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Volatility.R
\name{Volatility}
\alias{Volatility}
\alias{Volatility.MSGARCH_SPEC}
\alias{Volatility.MSGARCH_ML_FIT}
\alias{Volatility.MSGARCH_MCMC_FIT}
\title{Volatility filtering.}
\usage{
Volatility(object, ...)

\method{Volatility}{MSGARCH_SPEC}(object, par, data, ...)

\method{Volatility}{MSGARCH_ML_FIT}(object, newdata = NULL, ...)

\method{Volatility}{MSGARCH_MCMC_FIT}(object, newdata = NULL, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{Volatility}.}

\item{par}{Vector (of size d) or matrix (of size \code{nmcmc} x d) of parameter
estimates where d must have the same length as the default parameters of the specification.}

\item{data}{Vector (of size T) of observations.}

\item{newdata}{Vector (of size T*) of new observations. (Default \code{newdata = NULL})}
}
\value{
In-sample condititional volatility (vector of size T + T*) of class \code{MSGARCH_CONDVOL}.\cr
The \code{MSGARCH_CONDVOL} class contains the \code{plot} method.
}
\description{
Method returning the in-sample conditional volatility.
}
\details{
If a matrix of MCMC posterior draws is given, the
Bayesian predictive conditional volatility is calculated.
}
\examples{
# create specification
spec <- CreateSpec()

# load data
data("SMI", package = "MSGARCH")

# in-sample volatility from specification
par <- c(0.1, 0.1, 0.8, 0.2, 0.1, 0.8, 0.99, 0.01)
vol <- Volatility(object = spec, par = par, data = SMI)
head(vol)
plot(vol)

# in-sample volatility from ML fit
fit <- FitML(spec = spec, data = SMI)
vol <- Volatility(object = fit)
head(vol)
plot(vol)

\dontrun{
# in-sample volatility from MCMC fit
set.seed(1234)
fit <- FitMCMC(spec = spec, data = SMI)
vol <- Volatility(object = fit)
head(vol)
plot(vol)
}
}
