% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.MSGARCH_SPEC}
\alias{simulate.MSGARCH_SPEC}
\alias{simulate.MSGARCH_ML_FIT}
\alias{simulate.MSGARCH_MCMC_FIT}
\title{Simulation of MSGARCH processes.}
\usage{
\method{simulate}{MSGARCH_SPEC}(object, nsim = 1L, seed = NULL,
  nahead = 1L, par = NULL, nburn = 500L, ...)

\method{simulate}{MSGARCH_ML_FIT}(object, nsim = 1L, seed = NULL,
  nahead = 1L, nburn = 500L, ...)

\method{simulate}{MSGARCH_MCMC_FIT}(object, nsim = 1L, seed = NULL,
  nahead = 1L, nburn = 500L, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{CreateSpec}}
or fit object of type \code{MSGARCH_ML_FIT} created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{nsim}{Number of simulations. (Default: \code{nsim = 1L})}

\item{seed}{Integer indicateing if and how the random number generator should be initialized. 
If \code{seed = NULL},the state of the random generator will not change. (Default: \code{seed = NULL})
estimates where d must have the same length as the default parameters of the specification.}

\item{nahead}{Simulation length. (Default: \code{nahead = 1L})}

\item{par}{Vector (of size d) or matrix (of size \code{nahead} x d) of parameter}

\item{nburn}{Burnin period discarded (first simulation draws).}

\item{...}{Not used. Other arguments to \code{simulate}.}
}
\value{
A list of class \code{MSGARCH_SIM} with the following elements:.
\itemize{
\item \code{draw}: Matrix (of size \code{nahead} x \code{nsim}) of simulated draws.
\item \code{state}: Matrix (of size \code{nahead} x \code{nsim}) of simulated states.
\item \code{CondVol}: Array (of size \code{nahead} x \code{nsim} x K) of simulated conditional volatility.  
}
The \code{MSGARCH_SIM} class contains the \code{plot} method.
}
\description{
Method for simulating \code{MSGARCH} processes.
}
\details{
If a matrix of parameters estimates is provided, \code{nsim} simuations will be done for each row.
}
\examples{
# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# generate process
par.sim <- c(0.1,0.6,0.2,0.2,0.8,0.1,0.99,0.01)
set.seed(123)
sim <- simulate(object = spec, nsim = 1L, nahead = 1000L, nburnin = 500L, par = par.sim)
plot(sim)

# generate process after filtering for fitted model
# load data
data("SMI", package = "MSGARCH")

# fit the model on the data with ML estimation
fit <- FitML(spec = spec, data = SMI)

set.seed(123)
sim <- simulate(fit, nsim = 1000L, nahead = 30L)
plot(sim)
}
