% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pit.R
\name{PIT}
\alias{PIT}
\alias{PIT.MSGARCH_SPEC}
\alias{PIT.MSGARCH_ML_FIT}
\alias{PIT.MSGARCH_MCMC_FIT}
\title{Probability integral transform.}
\usage{
PIT(object, ...)

\method{PIT}{MSGARCH_SPEC}(object, x = NULL, par = NULL, data = NULL,
  do.norm = FALSE, do.its = FALSE, n.ahead = 1L, ctr = list(), ...)

\method{PIT}{MSGARCH_ML_FIT}(object, x = NULL, new.data = NULL,
  do.norm = TRUE, do.its = FALSE, n.ahead = 1L, ctr = list(), ...)

\method{PIT}{MSGARCH_MCMC_FIT}(object, x = NULL, new.data = NULL,
  do.norm = TRUE, do.its = FALSE, n.ahead = 1L, ctr = list(), ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT} created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{PIT}.}

\item{x}{Vector (of size n). Used when \code{do.its = FALSE}.}

\item{par}{Vector (of size d) or matrix (of size \code{n.mcmc} x d) of
parameter estimates where d must have
the same length as the default parameters of the specification.}

\item{data}{Vector (of size T) of observations.}

\item{do.norm}{Logical indicating if the PIT values are transformed
into standard Normal variate. (Default: \code{do.norm = FALSE})}

\item{do.its}{Logical indicating if the in-sample PIT is returned. (Default: \code{do.its = FALSE})}

\item{n.ahead}{Scalar indicating the number of step-ahead evaluation.
Valid only when \code{do.its = FALSE}. (Default: \code{n.ahead = 1L})}

\item{ctr}{A list of control parameters:
\itemize{
\item \code{n.sim} (integer >= 0):
Number indicating the number of simulation done for the
evaluation of the PIT at \code{n.ahead > 1}. (Default: \code{n.sim = 10000L})
}}

\item{new.data}{Vector (of size T*) of new observations. (Default \code{new.data = NULL})}
}
\value{
A vector or matrix of class \code{MSGARCH_PIT}. \cr
If \code{do.its = FALSE}: Probability integral transform of the
points \code{x} at \cr \code{t = T + T* + 1, ... ,t = T + T* + n.ahead} or Normal variate derived from the probability
integral transform of \code{x} (matrix of size \code{n.ahead} x n).\cr
If \code{do.its = TRUE}: In-sample  probability integral transform or Normal variate
derived from the probability integral transform of \code{data} if \code{x = NULL} (vector of
size T + T*) or in-sample  probability integral transform or Normal variate
derived from the probability integral transform of \code{x} (matrix of size   (T + T*) x n).
}
\description{
Method returning the probability integral
transform (PIT).
}
\details{
If a matrix of MCMC posterior draws is given, the
Bayesian probability integral transform is calculated.
Two or more step-ahead probability integral
transform are estimated via simulation of \code{n.sim} paths up to \code{t = T + T* + n.ahead}.
The empirical probability integral transforms is then inferred from these simulations.\cr
If \code{do.its = FALSE}, the vector \code{x} are evaluated as  \code{t = T + T* + 1, ... ,t = T + T* + n.ahead}
realizations.\cr
If \code{do.its = TRUE}, \code{x} is evaluated
at each time \code{t} up to time \code{t = T + T*}.\cr
Finally if \code{x = NULL} the vector \code{data} is evaluated for sample evaluation of the PIT.\cr
The \code{do.norm} argument transforms the PIT value into Normal variates so that normality test can be done.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on the data by ML
fit <- FitML(spec = spec, data = SMI)

# run PIT method in-sample
pit.its <- PIT(object = fit, do.norm = TRUE, do.its = TRUE)

# diagnostic of PIT with qqnorm
qqnorm(pit.its)
qqline(pit.its)

# simulate a serie from the model
set.seed(123)
sim.series <- Sim(object = spec, par = fit$par, n.ahead= 1000L, n.sim = 1L)
sim.series <- as.vector(sim.series$draw)

# run PIT method on the simualed serie with the true par
pit.x <- PIT(object = spec, par = fit$par, data = sim.series, do.norm = TRUE, do.its = TRUE)
qqnorm(pit.x)
qqline(pit.x)
}
