% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{fit.mle}
\alias{fit.mle}
\title{ML estimation.}
\usage{
fit.mle(spec, y, ctr = list())
}
\arguments{
\item{spec}{Model specification created with \code{\link{create.spec}}.}

\item{y}{Vector (of size T) of observations.}

\item{ctr}{List of control parameters.
The control parameters have two components to it:
\itemize{
\item \code{do.init} : Boolean indicating if there is a pre-optimization with the \R package \code{DEoptim} (Ardia et al., 2011). (Default: \code{do.init = TRUE})
\item \code{NP} : Number of parameter vectors in the population in \code{DEoptim} optimization. (Default: \code{NP = 200})
\item \code{itermax} : Maximum iteration (population generation) allowed in \code{DEoptim} optimization. (Default: \code{maxit = 200})
\item \code{do.enhance.theta0} : Boolean indicating if the default parameters value are enhance using \code{y} variance. (Default: \code{do.enhance.theta0 = TRUE})
}}
}
\value{
A list of class \code{MSGARCH_MLE_FIT} containing five components:
       \itemize{
       \item \code{theta} : Optimal parameters (vector of size d).
       \item \code{log_kernel} : log-kernel of \code{y} given the optimal parameters.
       \item \code{spec} : Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}.
       \item \code{is.init} : Indicating if estimation was made with do.init option.
       \item \code{y} :  Vector (of size T) of observations.
       }
The \code{MSGARCH_MLE_FIT} contains these methods:
\itemize{
\item \code{\link{AIC}} : Compute Akaike information criterion (AIC).
\item \code{\link{BIC}} : Compute Bayesian information criterion (BIC).
\item \code{\link{ht}}  : Conditional volatility in each regime.
\item \code{\link{kernel}} : Kernel method.
\item \code{\link{unc.vol}} : Unconditional volatility in each regime.
\item \code{\link{pred}} : Predictive method.
\item \code{\link{pit}} : Probability Integral Transform.
\item \code{\link{risk}} : Value-at-Risk And Expected-Shortfall methods.
\item \code{\link{simahead}} : Step ahead simulation method.
\item \code{\link{sim}} : Simulation method.
\item \code{\link{pdf}} : Probability density function.
\item \code{\link{cdf}} : Cumulative function.
\item \code{\link{Pstate}} : State probabilities filtering method.
\item \code{summary} : Summary of the fit.
}
}
\description{
Method that performs Maximum Likelihood estimation of a \code{MSGARCH_SPEC} object on a set of observations.
}
\details{
The Maximum likelihood estimation uses the \R package \code{nloptr} (Johnson, 2014) for main optimizer 
while it uses the \R package \code{DEoptim} when \code{do.init = TRUE} as an initialization for nloptr. 
 The argument \code{do.enhance.theta0}
 uses the volatilities of rolling windows of \code{y} and adjust the default parameter of
 the specification so that the unconditional volatility of each regime
 is set to different quantiles of the volatilities of the rolling windows of \code{y}.
}
\examples{
\dontrun{
# load data
data("sp500")

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with ML estimation using DEoptim intialization
set.seed(123)
fit = MSGARCH::fit.mle(spec = spec, y = sp500, 
                       ctr = list(do.init = TRUE, NP = 500, itermax = 500))
summary(fit)
  }           
}
\references{
Ardia, D. Boudt, K. Carl, P. Mullen, K. M. & Peterson, B. G. (2011). Differential Evolution with \code{DEoptim}. \emph{R Journal}, 3, pp. 27-34

Ardia, D. Mullen, K. M. Peterson, B. G. & Ulrich, J. (2015). \code{DEoptim}: Differential Evolution in \R. \url{https://cran.r-project.org/package=DEoptim}

Mullen, K. M. Ardia, D. Gil, D. L. Windover, D. Cline, J.(2011) \code{DEoptim}: An \R Package for Global Optimization by Differential Evolution. \emph{Journal of Statistical Software}, 40, pp. 1-26, DOI:	\url{http://dx.doi.org/10.18637/jss.v040.i06}

Johnson, S. G. (2014). The NLopt Nonlinear-Optimization. \url{https://cran.r-project.org/package=nloptr}.
}

