% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Empirical_MP.R
\name{smoothy}
\alias{smoothy}
\title{General purpose polynomial smoother}
\usage{
smoothy(xx, plot = F, enp_mult, plotname = "", xlab = "x", ylab = "y", x = NA)
}
\arguments{
\item{xx}{Vector of real numbers, data to be smoothed.}

\item{plot}{Logical, should the 'fit' of the smoother be plotted?}

\item{enp_mult}{Fraction, effective number of parameters multiplier. The smoother parameter number is length(xx) x enp_mult. So higher values of enp_mult means less smoothing (more parameters).}

\item{plotname}{Character, in case you want to put a label on the plot (plot = T).}

\item{xlab}{Character, in case you want an xaxis label on the plot (plot = T)}

\item{ylab}{Character, in case you want a yaxis label on the plot (plot = T)}

\item{x}{Numeric vector same length as xx, in case you want to have a custom xaxis (e.g. years)}
}
\description{
Polynomial smoother (no gradient prediction) applied to a vector that can include NA values. Intended to be rapid for use in management procedures
}
\author{
T. Carruthers
}
