% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic_AM.R
\name{diagnostic_AM}
\alias{diagnostic_AM}
\title{diagnostic_AM (diagnostic of Assessments in MSE): Did Assess models converge during MSE?}
\usage{
diagnostic_AM(MSE, MP = NULL, gradient_threshold = 0.1,
  figure = TRUE)
}
\arguments{
\item{MSE}{An object of class MSE created by \code{\link[DLMtool]{runMSE}}. If no MSE object
is available, use argument \code{MP} instead.}

\item{MP}{A character vector of MPs with assessment models.}

\item{gradient_threshold}{The maximum magnitude (absolute value) desired for the gradient of the likelihood.}

\item{figure}{Logical, whether a figure will be drawn.}
}
\value{
A matrix with diagnostic performance of assessment models in the MSE. If \code{figure = TRUE},
a set of figures: traffic light (red/green) plots indicating whether the model converged (defined if a positive-definite
Hessian matrix was obtained), the optimizer reached pre-specified iteration limits (as passed to \code{\link[stats]{nlminb}}),
and the maximum gradient of the likelihood in each assessment run. Also includes the number of optimization iterations
function evaluations reported by \code{\link[stats]{nlminb}} for each application of the assessment model.
}
\description{
Diagnostic check for convergence of Assess models during MSE.
Assess models write output to the DLMenv environment if the MP was created with \link{make_MP}
with argument \code{diagnostic = TRUE}. This function summarizes and plots the diagnostic information.
}
\examples{
\dontrun{
DD_MSY <- make_MP(DD_TMB, HCR_MSY, diagnostic = "min")
show(DD_MSY)

##### Ensure that PPD = TRUE in runMSE function
myMSE <- runMSE(DLMtool::testOM, MPs = "DD_MSY", PPD = TRUE)
diagnostic_AM(myMSE)
}
}
\seealso{
\link{retrospective_AM}
}
\author{
Q. Huynh
}
