% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn_MICE.R
\name{popdynMICE}
\alias{popdynMICE}
\title{Population dynamics for a MICE model (multiyear)}
\usage{
popdynMICE(qsx, qfracx, np, nf, nyears, nareas, maxage, Nx, VFx, FretAx,
  Effind, movx, Spat_targ, M_ageArrayx, Mat_agex, Asizex, Kx, Linfx, t0x,
  Mx, R0x, R0ax, SSBpRx, hsx, aRx, bRx, ax, bx, Perrx, SRrelx, Rel,
  SexPars, x)
}
\arguments{
\item{qsx}{Total catchability}

\item{qfracx}{Vector [fleet], the fraction of total qs by fleet}

\item{np}{Integer, the number of stocks}

\item{nf}{Integer, number of fleets}

\item{nyears}{Integer, number of historical years (unfished til today)}

\item{nareas}{Integer, the number of spatial areas}

\item{maxage}{Integer, maximum modelled age}

\item{Nx}{Array [stock, age, year, area] of stock numbers}

\item{VFx}{Array [fleet, age, year, area] of the vulnerability curve}

\item{FretAx}{Array [fleet, age, year, area] of the retention curve}

\item{Effind}{Array [fleet, year] of effort}

\item{movx}{Array [stock,age,area,area] of movement transitions}

\item{Spat_targ}{Matrix [stock, fleet] of spatial targetting parameter (0 evenly spatial distributed, 1 proportional to vulnerable biomass)}

\item{M_ageArrayx}{Array [stock, age,year] of Natural mortality rate at age}

\item{Mat_agex}{Array [stock, age, year] of maturity (spawning fraction) age}

\item{Asizex}{Array [stock, area] Area size}

\item{Kx}{Vector [stock] of von B growth parameter K}

\item{Mx}{Vector [stock] mature natural mortality rate}

\item{R0x}{Vector [stock] unfished recruitment}

\item{R0ax}{Matrix [stock, area] unfished recruitment by area}

\item{SSBpRx}{Matrix [stock, area] spawning biomass per recruit by area}

\item{hsx}{Vector [stock] steepness of the stock recruitment curve}

\item{aRx}{Vector [stock] stock recruitment parameter alpha (for Ricker curve)}

\item{bRx}{Vector [stock] stock recruitment parameter beta (for Ricker curve)}

\item{ax}{Vector [stock] weight-length parameter a W=aL^b}

\item{bx}{Vector [stock] weight-length parameter b W=aL^b}

\item{Perrx}{Matrix [stock, year] process error - the lognormal factor for recruitment strength}

\item{SRrelx}{Integer vector [stock] the form of the stock recruitment relationship (1 = Beverton-Holt, 2= Ricker)}

\item{Rel}{A list of inter-stock relationships see slot Rel of MOM object class}

\item{SexPars}{A list of sex-specific relationships (SSBfrom, stock_age)}

\item{x}{Integer the simulation number}

\item{Linf}{Vector [stock] of von B asymptotic length parameter Linf}

\item{t0}{Vector [stock] of von B theoretical age at zero length (t0)}
}
\description{
Calls popdynOneMICE iteratively to reconstruct a time series given MICE model inputs
}
\author{
T.Carruthers
}
\keyword{internal}
