% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Make_MP.R
\name{make_MP}
\alias{make_MP}
\title{Make a custom management procedure (MP)}
\usage{
make_MP(.Assess, .HCR, diagnostic = c("none", "min", "full"), ...)
}
\arguments{
\item{.Assess}{A function of class \code{Assess}.}

\item{.HCR}{A function of class \code{HCR}.}

\item{diagnostic}{A character string describing if any additional diagnostic information from the
assessment models will be collected during a call with \code{\link[DLMtool]{runMSE}} (\code{"none"} is the
default). \code{"min"} (minimal) will collect information on convergence and \code{"full"} will also collect the
Assessment object generated by the \code{.Assess}. This information will be written to \code{\link[DLMtool]{DLMenv}}.
See example.}

\item{...}{Additional arguments to be passed to \code{.Assess} and \code{.HCR}.}
}
\value{
A function of class \code{MP}.
}
\description{
Function operator that combines a function of class \code{Assess} and a function of
class \code{HCR} to create a management procedure (MP). The resulting function
can then be tested in closed-loop simulation via \code{\link[DLMtool]{runMSE}}.
}
\examples{
# A delay-difference model with a 40-10 control rule
DD_40_10 <- make_MP(DD_TMB, HCR40_10)

# A delay difference model that will produce convergence diagnostics
DD_40_10 <- make_MP(DD_TMB, HCR40_10, diagnostic = "min")

# MP that uses a Delay-Difference which assumes a Ricker stock-recruit function.
DD_Ricker <- make_MP(DD_TMB, HCR_MSY, SR = "Ricker")

\dontrun{
myMSE <- DLMtool::runMSE(DLMtool::testOM, MPs = c("FMSYref", "DD_40_10"))

ls(DLMenv) # Model output during MSE is assigned to this environment.
diagnostic_AM(myMSE)
}

}
\seealso{
\link{diagnostic_AM} \link{retrospective_AM}
}
