% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ancillary_Indicators.R
\name{PRBcalc}
\alias{PRBcalc}
\title{Calculate mahalanobis distance (null and alternative MSEs) and statistical power for all MPs in an MSE}
\usage{
PRBcalc(MSE_null, MSE_alt, tsd = c("Cat", "Cat", "Cat", "Ind", "ML"),
  stat = c("slp", "AAV", "mu", "slp", "slp"), dnam = c("C_S", "C_V", "C_M",
  "I_S", "ML_S"), res = 6, alpha = 0.05, plotCC = FALSE,
  removedat = FALSE, removethresh = 0.025)
}
\arguments{
\item{MSE_null}{An object of class MSE representing the null hypothesis}

\item{MSE_alt}{An object of class MSE representing the alternative hypothesis}

\item{tsd}{Character string of data types: Cat = catch, Ind = relative abundance index, ML = mean length in catches}

\item{stat}{Character string defining the quantity to be calculated for each data type, slp = slope(log(x)), AAV = average annual variability, mu = mean(log(x))}

\item{dnam}{Character string of names for the quantities calculated}

\item{res}{Integer, the resolution (time blocking) for the calculation of PPD}

\item{alpha}{Probability of incorrectly rejecting the null operating model when it is valid}

\item{plotCC}{Logical, should the PPD cross correlations be plotted?}

\item{removedat}{Logical, should data not contributing to the mahalanobis distance be removed?}

\item{removethresh}{Positive fraction: the cumulative percentage of removed data (removedat=TRUE) that contribute to the mahalanobis distance}
}
\value{
A list object (first hierarcy is by MP, second has two positions one mahalanobis distance, two is a matrix of type 1 error (first row) and statistical power (second row), by time block)
}
\description{
Calculate mahalanobis distance (null and alternative MSEs) and statistical power for all MPs in an MSE
}
\references{
Carruthers and Hordyk 2018
}
\author{
T. Carruthers
}
