% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectBitInfo.R
\name{detectBitInfo}
\alias{detectBitInfo}
\title{List MODIS Quality Information}
\usage{
detectBitInfo(product, what = "all", warn = TRUE)
}
\arguments{
\item{product}{\code{character}, see \code{\link{getProduct}}.}

\item{what}{\code{character}. Parameter name, e.g. 'VI Quality' for all MOD13
products (see \href{https://lpdaac.usgs.gov/sites/default/files/public/product_documentation/mod13_user_guide.pdf}{MODIS Vegetation Index User's Guide}, 
Table 5, Parameter Name).}

\item{warn}{\code{logical}, whether or not to throw warning messages.}
}
\value{
If \code{what = "all"} a \code{data.frame}, else a \code{list}.
}
\description{
This function returns MODIS QA information for a specific product. It gets 
the information from an internal database and not all products are available.
}
\examples{
detectBitInfo("MOD13Q1")
detectBitInfo("MOD13Q1", "VI usefulness")

detectBitInfo("MYD17A2")

}
\author{
Matteo Mattiuzzi
}
