% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Classification.R
\name{ConfusionMatrix}
\alias{ConfusionMatrix}
\title{Confusion Matrix}
\usage{
ConfusionMatrix(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) labels vector}

\item{y_pred}{Predicted labels vector, as returned by a classifier}
}
\value{
a table of Confusion Matrix
}
\description{
Compute confusion matrix to evaluate the accuracy of a classification.
}
\examples{
data(cars)
logreg <- glm(formula=vs~hp+wt, family=binomial(link = "logit"), mtcars)
pred <- ifelse(logreg$fitted.values<0.5, 0, 1)
ConfusionMatrix(y_true=mtcars$vs, y_pred=pred)
}

