\name{AIC.mlds}
\alias{AIC.mlds}

\title{ Extract AIC from Object of Class 'mlds' }
\description{
This function calculates the Akaike information criterion from the fitted model object generated by \code{mlds} from the formula \eqn{-2*log(likelihood) + k*npar}, where \eqn{npar} represents the number of parameters in the fitted model and \eqn{k = 2} for the usual AIC or \eqn{k = log(n)} (\eqn{n} the number of observations for the so-called BIC or SBC (Schwarz's Bayesian criterion).
}
\usage{
\method{AIC}{mlds}(object, ..., k = 2)
}

\arguments{
  \item{object}{ an object of class 'mlds'. }
  \item{\dots}{not used for the moment}
  \item{k}{numeric, the "penalty" per parameter to be used, the default \code{k = 2} is the classical AIC. }
}
\details{
 The method depends on the \code{link{logLik.mlds}} method computing the log-likelihood for the 'mlds' class.  The smaller the AIC, the better the fit. The log-likelihood and hence the AIC is only defined up to an additive constant.  
}
\value{
  Returns a numeric value with the corresponding AIC (or BIC, or ..., depending on \code{k)}.  
  }
\references{Sakamoto, Y., Ishiguro, M., and Kitagawa G. (1986). Akaike Information Criterion Statistics. D. Reidel Publishing Company. }
\author{ Kenneth Knoblauch}

\seealso{ \code{\link{logLik.mlds}}}
\examples{
data(AutumnLab)
AIC(mlds(AutumnLab, method = "optim", opt.init = c(seq(0, 1, len = 10), 0.2)))

}
\keyword{univar}
