% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_functions.R
\name{vae_loss_correlated}
\alias{vae_loss_correlated}
\title{A custom loss function for a VAE learning a multivariate normal distribution with a full covariance matrix}
\usage{
vae_loss_correlated(
  encoder,
  inv_skill_cov,
  det_skill_cov,
  skill_mean,
  kl_weight,
  rec_dim
)
}
\arguments{
\item{encoder}{the encoder model of the VAE, used to obtain z_mean and z_log_cholesky from inputs}

\item{inv_skill_cov}{a constant tensor matrix of the inverse of the covariance matrix being learned}

\item{det_skill_cov}{a constant tensor scalar representing the determinant of the covariance matrix being learned}

\item{skill_mean}{a constant tensor vector representing the means of the latent skills being learned}

\item{kl_weight}{weight for the KL divergence term}

\item{rec_dim}{the number of nodes in the input/output of the VAE}
}
\value{
returns a function whose parameters match keras loss format
}
\description{
A custom loss function for a VAE learning a multivariate normal distribution with a full covariance matrix
}
