% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIIVsem-data.R
\docType{data}
\name{bollen1989b}
\alias{bollen1989b}
\title{Union sentiment data}
\format{
A data frame with 173 rows and 5 variables
}
\usage{
bollen1989b
}
\description{
A dataset from McDonald and Clelland (1984) reanalyzed by
Bollen (1989) containing data on union sentiment of
southern nonunion textile workers.
}
\details{
\itemize{
  \item deferenc. deference (submissiveness) to managers
  \item laboract. support for labor activism
  \item unionsen. sentiment towards unions
  \item yrsmill. log of years spent in textile mill
  \item age. centered age
}
}
\examples{

\dontrun{
 model <- '
   unionsen ~  deferenc + laboract + yrsmill
   deferenc ~  age
   laboract ~  age + deferenc
   yrsmill  ~~ age
 '
}

}
\references{
Bollen, K. A. 1989. Structural Equations with Latent Variables. 
  New York: Wiley
  
  McDonald, A, J., & Clelland, D. A. (1984). Textile Workers 
  and Union Sentiment. Social Forces, 63(2), 502–521.
}
\keyword{datasets}
