% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bolshev.rec.vec.R
\name{bolshev.rec.vec}
\alias{bolshev.rec.vec}
\title{Distribution function of the order statistics of i.i.d. uniform random variables}
\usage{
bolshev.rec.vec(m)
}
\arguments{
\item{m}{matrix whose columns are p-values sorted in descending order}
}
\value{
matrix p containing the calculated probabilities
}
\description{
\code{bolshev.rec.vec} is a vectorized and unrolled implementation of the Bolshev recursion described in Shorack, Wellner (1986)
which can be utilized to calculate probabilities for order statistics of i.i.d. uniform random variables.
}
\details{
Denote by \eqn{U_1,\cdots,U_n} n i.i.d. uniform random variables on \eqn{[0,1]}. Denote by \eqn{U_{1:n},\cdots,U_{n:n}} their order statistics.
Then the return value \code{p} contains the probabilities \deqn{p[i,j] = P\left(\bigcap\limits_{k=i}^n\left\{m[n-k+1,j] \le U_{k:n}\right\}\right)}{p[i,j] = P(\forall k=i,\cdots,n: m[n-k+1,j] \le U_{k:n})}
}
\examples{
bolshev.rec.vec(cbind(rev(c(0.7,0.8,0.9))))
#result: c(0.016, 0.079, 0.271)
#monte carlo simulation
sim <- function(v) mean(replicate(1e4,all(v <= sort(runif(3)))))
set.seed(0)
c(sim(c(0.7,0.8,0.9)),sim(c(0,0.8,0.9)),sim(c(0,0,0.9)))
#similar result: c(0.0176, 0.0799, 0.2709)
}
\references{
G. R. Shorack and J. A. Wellner (1986). Empirical Processes with Applications to Statistics
}
