\name{ed}
\alias{ed}
\title{Calculate alpha, beta and gamma true entropies and diversities}
\description{
Calculates alpha, beta and gamma true diversities of a data set.
The matrix or data frame is automatically scaled to row sums of one.}
\usage{
ed(x, q = 1, w = 1, retq = TRUE)
}
\arguments{
  \item{x}{
the input matrix or data frame.
}
  \item{q}{
the order of diversity; typically 0, 1 or 2.
}
  \item{w}{
weights if required.
}
  \item{retq}{
if TRUE then diversities are returned; if FALSE the entropies for alpha and gamma are returned.
}
}
\value{
a vector of entropies or diversities
}
\seealso{
\code{\link{dev2div}}, \code{\link{ed1}}, \code{\link{eds}}, \code{\link{eds1}}
}
\examples{
data(spider6)
ed(spider6[,1:6])
ed(spider6[,1:6],q=0)
ed(spider6[,1:6],q=2)
ed(spider6[,1:6],retq=FALSE)
data(spider6)
ed(spider6[,1:6])
}
