% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeToPhy.R
\name{nodeToPhy}
\alias{nodeToPhy}
\title{Add Node Constraints to Tree in MCMCtree Format}
\usage{
nodeToPhy(phy, monoGroups, nodeCon, returnPhy = TRUE)
}
\arguments{
\item{phy}{fully resolved phylogeny in ape format}

\item{monoGroups}{list  with each element containing species that define a node of interest}

\item{nodeCon}{node distributions in MCMCtreeR format}

\item{returnPhy}{logical specifying whether to return phy to console or write MCMCtree for input (default = TRUE)}
}
\value{
If returnPhy=TRUE phylogeny with node labels in ape format

If returnPhy=FALSE phylogeny with node labels in MCMCtree format
}
\description{
Produce tree with node labels in MCMCtree format
}
\examples{
data(apeData)
attach(apeData)
monophyleticGroups[[1]] <- c("human", "chimpanzee",
"bonobo", "gorilla", "sumatran", "orangutan", "gibbon")
monophyleticGroups[[2]] <- c("human", "chimpanzee",
"bonobo", "gorilla")
monophyleticGroups[[3]] <- c("human", "chimpanzee", "bonobo")
monophyleticGroups[[4]] <- c("sumatran", "orangutan")
minimumTimes <- c("nodeOne"=15, "nodeTwo"=6,
"nodeThree"=8, "nodeFour"=13) / 10
maximumTimes <- c("nodeOne"=30, "nodeTwo"=12,
"nodeThree"=12, "nodeFour"=20) / 10
boundEst <- estimateBound(minAge=minimumTimes[1], maxAge=maximumTimes[1],
monoGroups=monophyleticGroups[[1]], phy=apeTree, plot=FALSE)
}
